/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest;
import com.amazonaws.services.ec2.model.IcmpTypeCode;
import com.amazonaws.services.ec2.model.PortRange;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateNetworkAclEntryRequestMarshaller
implements Marshaller<Request<CreateNetworkAclEntryRequest>, CreateNetworkAclEntryRequest> {
    public Request<CreateNetworkAclEntryRequest> marshall(CreateNetworkAclEntryRequest createNetworkAclEntryRequest) {
        PortRange portRange;
        IcmpTypeCode icmpTypeCode;
        if (createNetworkAclEntryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createNetworkAclEntryRequest, "AmazonEC2");
        request.addParameter("Action", "CreateNetworkAclEntry");
        request.addParameter("Version", "2016-04-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createNetworkAclEntryRequest.getNetworkAclId() != null) {
            request.addParameter("NetworkAclId", StringUtils.fromString((String)createNetworkAclEntryRequest.getNetworkAclId()));
        }
        if (createNetworkAclEntryRequest.getRuleNumber() != null) {
            request.addParameter("RuleNumber", StringUtils.fromInteger((Integer)createNetworkAclEntryRequest.getRuleNumber()));
        }
        if (createNetworkAclEntryRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString((String)createNetworkAclEntryRequest.getProtocol()));
        }
        if (createNetworkAclEntryRequest.getRuleAction() != null) {
            request.addParameter("RuleAction", StringUtils.fromString((String)createNetworkAclEntryRequest.getRuleAction()));
        }
        if (createNetworkAclEntryRequest.getEgress() != null) {
            request.addParameter("Egress", StringUtils.fromBoolean((Boolean)createNetworkAclEntryRequest.getEgress()));
        }
        if (createNetworkAclEntryRequest.getCidrBlock() != null) {
            request.addParameter("CidrBlock", StringUtils.fromString((String)createNetworkAclEntryRequest.getCidrBlock()));
        }
        if ((icmpTypeCode = createNetworkAclEntryRequest.getIcmpTypeCode()) != null) {
            if (icmpTypeCode.getType() != null) {
                request.addParameter("Icmp.Type", StringUtils.fromInteger((Integer)icmpTypeCode.getType()));
            }
            if (icmpTypeCode.getCode() != null) {
                request.addParameter("Icmp.Code", StringUtils.fromInteger((Integer)icmpTypeCode.getCode()));
            }
        }
        if ((portRange = createNetworkAclEntryRequest.getPortRange()) != null) {
            if (portRange.getFrom() != null) {
                request.addParameter("PortRange.From", StringUtils.fromInteger((Integer)portRange.getFrom()));
            }
            if (portRange.getTo() != null) {
                request.addParameter("PortRange.To", StringUtils.fromInteger((Integer)portRange.getTo()));
            }
        }
        return request;
    }
}

