/*
 * Copyright 2011-2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not
 * use this file except in compliance with the License. A copy of the License is
 * located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.ec2.model;

import java.io.Serializable;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.transform.ModifySubnetAttributeRequestMarshaller;

/**
 * <p>
 * Contains the parameters for ModifySubnetAttribute.
 * </p>
 */
public class ModifySubnetAttributeRequest extends AmazonWebServiceRequest
        implements Serializable, Cloneable,
        DryRunSupportedRequest<ModifySubnetAttributeRequest> {

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     */
    private String subnetId;
    /**
     * <p>
     * Specify <code>true</code> to indicate that instances launched into the
     * specified subnet should be assigned public IP address.
     * </p>
     */
    private Boolean mapPublicIpOnLaunch;

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @param subnetId
     *        The ID of the subnet.
     */

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */

    public String getSubnetId() {
        return this.subnetId;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @param subnetId
     *        The ID of the subnet.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public ModifySubnetAttributeRequest withSubnetId(String subnetId) {
        setSubnetId(subnetId);
        return this;
    }

    /**
     * <p>
     * Specify <code>true</code> to indicate that instances launched into the
     * specified subnet should be assigned public IP address.
     * </p>
     * 
     * @param mapPublicIpOnLaunch
     *        Specify <code>true</code> to indicate that instances launched into
     *        the specified subnet should be assigned public IP address.
     */

    public void setMapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
        this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
    }

    /**
     * <p>
     * Specify <code>true</code> to indicate that instances launched into the
     * specified subnet should be assigned public IP address.
     * </p>
     * 
     * @return Specify <code>true</code> to indicate that instances launched
     *         into the specified subnet should be assigned public IP address.
     */

    public Boolean getMapPublicIpOnLaunch() {
        return this.mapPublicIpOnLaunch;
    }

    /**
     * <p>
     * Specify <code>true</code> to indicate that instances launched into the
     * specified subnet should be assigned public IP address.
     * </p>
     * 
     * @param mapPublicIpOnLaunch
     *        Specify <code>true</code> to indicate that instances launched into
     *        the specified subnet should be assigned public IP address.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public ModifySubnetAttributeRequest withMapPublicIpOnLaunch(
            Boolean mapPublicIpOnLaunch) {
        setMapPublicIpOnLaunch(mapPublicIpOnLaunch);
        return this;
    }

    /**
     * <p>
     * Specify <code>true</code> to indicate that instances launched into the
     * specified subnet should be assigned public IP address.
     * </p>
     * 
     * @return Specify <code>true</code> to indicate that instances launched
     *         into the specified subnet should be assigned public IP address.
     */

    public Boolean isMapPublicIpOnLaunch() {
        return this.mapPublicIpOnLaunch;
    }

    /**
     * This method is intended for internal use only. Returns the marshaled
     * request configured with additional parameters to enable operation
     * dry-run.
     */
    @Override
    public Request<ModifySubnetAttributeRequest> getDryRunRequest() {
        Request<ModifySubnetAttributeRequest> request = new ModifySubnetAttributeRequestMarshaller()
                .marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSubnetId() != null)
            sb.append("SubnetId: " + getSubnetId() + ",");
        if (getMapPublicIpOnLaunch() != null)
            sb.append("MapPublicIpOnLaunch: " + getMapPublicIpOnLaunch());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ModifySubnetAttributeRequest == false)
            return false;
        ModifySubnetAttributeRequest other = (ModifySubnetAttributeRequest) obj;
        if (other.getSubnetId() == null ^ this.getSubnetId() == null)
            return false;
        if (other.getSubnetId() != null
                && other.getSubnetId().equals(this.getSubnetId()) == false)
            return false;
        if (other.getMapPublicIpOnLaunch() == null
                ^ this.getMapPublicIpOnLaunch() == null)
            return false;
        if (other.getMapPublicIpOnLaunch() != null
                && other.getMapPublicIpOnLaunch().equals(
                        this.getMapPublicIpOnLaunch()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode
                + ((getSubnetId() == null) ? 0 : getSubnetId().hashCode());
        hashCode = prime
                * hashCode
                + ((getMapPublicIpOnLaunch() == null) ? 0
                        : getMapPublicIpOnLaunch().hashCode());
        return hashCode;
    }

    @Override
    public ModifySubnetAttributeRequest clone() {
        return (ModifySubnetAttributeRequest) super.clone();
    }
}
