/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ServiceTypeDetail;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ServiceDetail
implements Serializable,
Cloneable {
    private String serviceName;
    private SdkInternalList<ServiceTypeDetail> serviceType;
    private SdkInternalList<String> availabilityZones;
    private String owner;
    private SdkInternalList<String> baseEndpointDnsNames;
    private String privateDnsName;
    private Boolean vpcEndpointPolicySupported;
    private Boolean acceptanceRequired;

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ServiceDetail withServiceName(String serviceName) {
        this.setServiceName(serviceName);
        return this;
    }

    public List<ServiceTypeDetail> getServiceType() {
        if (this.serviceType == null) {
            this.serviceType = new SdkInternalList();
        }
        return this.serviceType;
    }

    public void setServiceType(Collection<ServiceTypeDetail> serviceType) {
        if (serviceType == null) {
            this.serviceType = null;
            return;
        }
        this.serviceType = new SdkInternalList(serviceType);
    }

    public ServiceDetail withServiceType(ServiceTypeDetail ... serviceType) {
        if (this.serviceType == null) {
            this.setServiceType((Collection<ServiceTypeDetail>)new SdkInternalList(serviceType.length));
        }
        for (ServiceTypeDetail ele : serviceType) {
            this.serviceType.add((Object)ele);
        }
        return this;
    }

    public ServiceDetail withServiceType(Collection<ServiceTypeDetail> serviceType) {
        this.setServiceType(serviceType);
        return this;
    }

    public List<String> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new SdkInternalList();
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        this.availabilityZones = new SdkInternalList(availabilityZones);
    }

    public ServiceDetail withAvailabilityZones(String ... availabilityZones) {
        if (this.availabilityZones == null) {
            this.setAvailabilityZones((Collection<String>)new SdkInternalList(availabilityZones.length));
        }
        for (String ele : availabilityZones) {
            this.availabilityZones.add((Object)ele);
        }
        return this;
    }

    public ServiceDetail withAvailabilityZones(Collection<String> availabilityZones) {
        this.setAvailabilityZones(availabilityZones);
        return this;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public ServiceDetail withOwner(String owner) {
        this.setOwner(owner);
        return this;
    }

    public List<String> getBaseEndpointDnsNames() {
        if (this.baseEndpointDnsNames == null) {
            this.baseEndpointDnsNames = new SdkInternalList();
        }
        return this.baseEndpointDnsNames;
    }

    public void setBaseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
        if (baseEndpointDnsNames == null) {
            this.baseEndpointDnsNames = null;
            return;
        }
        this.baseEndpointDnsNames = new SdkInternalList(baseEndpointDnsNames);
    }

    public ServiceDetail withBaseEndpointDnsNames(String ... baseEndpointDnsNames) {
        if (this.baseEndpointDnsNames == null) {
            this.setBaseEndpointDnsNames((Collection<String>)new SdkInternalList(baseEndpointDnsNames.length));
        }
        for (String ele : baseEndpointDnsNames) {
            this.baseEndpointDnsNames.add((Object)ele);
        }
        return this;
    }

    public ServiceDetail withBaseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
        this.setBaseEndpointDnsNames(baseEndpointDnsNames);
        return this;
    }

    public void setPrivateDnsName(String privateDnsName) {
        this.privateDnsName = privateDnsName;
    }

    public String getPrivateDnsName() {
        return this.privateDnsName;
    }

    public ServiceDetail withPrivateDnsName(String privateDnsName) {
        this.setPrivateDnsName(privateDnsName);
        return this;
    }

    public void setVpcEndpointPolicySupported(Boolean vpcEndpointPolicySupported) {
        this.vpcEndpointPolicySupported = vpcEndpointPolicySupported;
    }

    public Boolean getVpcEndpointPolicySupported() {
        return this.vpcEndpointPolicySupported;
    }

    public ServiceDetail withVpcEndpointPolicySupported(Boolean vpcEndpointPolicySupported) {
        this.setVpcEndpointPolicySupported(vpcEndpointPolicySupported);
        return this;
    }

    public Boolean isVpcEndpointPolicySupported() {
        return this.vpcEndpointPolicySupported;
    }

    public void setAcceptanceRequired(Boolean acceptanceRequired) {
        this.acceptanceRequired = acceptanceRequired;
    }

    public Boolean getAcceptanceRequired() {
        return this.acceptanceRequired;
    }

    public ServiceDetail withAcceptanceRequired(Boolean acceptanceRequired) {
        this.setAcceptanceRequired(acceptanceRequired);
        return this;
    }

    public Boolean isAcceptanceRequired() {
        return this.acceptanceRequired;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServiceName() != null) {
            sb.append("ServiceName: ").append(this.getServiceName()).append(",");
        }
        if (this.getServiceType() != null) {
            sb.append("ServiceType: ").append(this.getServiceType()).append(",");
        }
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.getAvailabilityZones()).append(",");
        }
        if (this.getOwner() != null) {
            sb.append("Owner: ").append(this.getOwner()).append(",");
        }
        if (this.getBaseEndpointDnsNames() != null) {
            sb.append("BaseEndpointDnsNames: ").append(this.getBaseEndpointDnsNames()).append(",");
        }
        if (this.getPrivateDnsName() != null) {
            sb.append("PrivateDnsName: ").append(this.getPrivateDnsName()).append(",");
        }
        if (this.getVpcEndpointPolicySupported() != null) {
            sb.append("VpcEndpointPolicySupported: ").append(this.getVpcEndpointPolicySupported()).append(",");
        }
        if (this.getAcceptanceRequired() != null) {
            sb.append("AcceptanceRequired: ").append(this.getAcceptanceRequired());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDetail)) {
            return false;
        }
        ServiceDetail other = (ServiceDetail)obj;
        if (other.getServiceName() == null ^ this.getServiceName() == null) {
            return false;
        }
        if (other.getServiceName() != null && !other.getServiceName().equals(this.getServiceName())) {
            return false;
        }
        if (other.getServiceType() == null ^ this.getServiceType() == null) {
            return false;
        }
        if (other.getServiceType() != null && !other.getServiceType().equals(this.getServiceType())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !other.getAvailabilityZones().equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getOwner() == null ^ this.getOwner() == null) {
            return false;
        }
        if (other.getOwner() != null && !other.getOwner().equals(this.getOwner())) {
            return false;
        }
        if (other.getBaseEndpointDnsNames() == null ^ this.getBaseEndpointDnsNames() == null) {
            return false;
        }
        if (other.getBaseEndpointDnsNames() != null && !other.getBaseEndpointDnsNames().equals(this.getBaseEndpointDnsNames())) {
            return false;
        }
        if (other.getPrivateDnsName() == null ^ this.getPrivateDnsName() == null) {
            return false;
        }
        if (other.getPrivateDnsName() != null && !other.getPrivateDnsName().equals(this.getPrivateDnsName())) {
            return false;
        }
        if (other.getVpcEndpointPolicySupported() == null ^ this.getVpcEndpointPolicySupported() == null) {
            return false;
        }
        if (other.getVpcEndpointPolicySupported() != null && !other.getVpcEndpointPolicySupported().equals(this.getVpcEndpointPolicySupported())) {
            return false;
        }
        if (other.getAcceptanceRequired() == null ^ this.getAcceptanceRequired() == null) {
            return false;
        }
        return other.getAcceptanceRequired() == null || other.getAcceptanceRequired().equals(this.getAcceptanceRequired());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServiceName() == null ? 0 : this.getServiceName().hashCode());
        hashCode = 31 * hashCode + (this.getServiceType() == null ? 0 : this.getServiceType().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getOwner() == null ? 0 : this.getOwner().hashCode());
        hashCode = 31 * hashCode + (this.getBaseEndpointDnsNames() == null ? 0 : this.getBaseEndpointDnsNames().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateDnsName() == null ? 0 : this.getPrivateDnsName().hashCode());
        hashCode = 31 * hashCode + (this.getVpcEndpointPolicySupported() == null ? 0 : this.getVpcEndpointPolicySupported().hashCode());
        hashCode = 31 * hashCode + (this.getAcceptanceRequired() == null ? 0 : this.getAcceptanceRequired().hashCode());
        return hashCode;
    }

    public ServiceDetail clone() {
        try {
            return (ServiceDetail)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

