/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ClientData;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.ImageDiskContainer;
import com.amazonaws.services.ec2.model.transform.ImportImageRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ImportImageRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ImportImageRequest> {
    private String description;
    private SdkInternalList<ImageDiskContainer> diskContainers;
    private String licenseType;
    private String hypervisor;
    private String architecture;
    private String platform;
    private ClientData clientData;
    private String clientToken;
    private String roleName;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ImportImageRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<ImageDiskContainer> getDiskContainers() {
        if (this.diskContainers == null) {
            this.diskContainers = new SdkInternalList();
        }
        return this.diskContainers;
    }

    public void setDiskContainers(Collection<ImageDiskContainer> diskContainers) {
        if (diskContainers == null) {
            this.diskContainers = null;
            return;
        }
        this.diskContainers = new SdkInternalList(diskContainers);
    }

    public ImportImageRequest withDiskContainers(ImageDiskContainer ... diskContainers) {
        if (this.diskContainers == null) {
            this.setDiskContainers((Collection<ImageDiskContainer>)new SdkInternalList(diskContainers.length));
        }
        for (ImageDiskContainer ele : diskContainers) {
            this.diskContainers.add((Object)ele);
        }
        return this;
    }

    public ImportImageRequest withDiskContainers(Collection<ImageDiskContainer> diskContainers) {
        this.setDiskContainers(diskContainers);
        return this;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public ImportImageRequest withLicenseType(String licenseType) {
        this.setLicenseType(licenseType);
        return this;
    }

    public void setHypervisor(String hypervisor) {
        this.hypervisor = hypervisor;
    }

    public String getHypervisor() {
        return this.hypervisor;
    }

    public ImportImageRequest withHypervisor(String hypervisor) {
        this.setHypervisor(hypervisor);
        return this;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public ImportImageRequest withArchitecture(String architecture) {
        this.setArchitecture(architecture);
        return this;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatform() {
        return this.platform;
    }

    public ImportImageRequest withPlatform(String platform) {
        this.setPlatform(platform);
        return this;
    }

    public void setClientData(ClientData clientData) {
        this.clientData = clientData;
    }

    public ClientData getClientData() {
        return this.clientData;
    }

    public ImportImageRequest withClientData(ClientData clientData) {
        this.setClientData(clientData);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public ImportImageRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public ImportImageRequest withRoleName(String roleName) {
        this.setRoleName(roleName);
        return this;
    }

    @Override
    public Request<ImportImageRequest> getDryRunRequest() {
        Request<ImportImageRequest> request = new ImportImageRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getDiskContainers() != null) {
            sb.append("DiskContainers: " + this.getDiskContainers() + ",");
        }
        if (this.getLicenseType() != null) {
            sb.append("LicenseType: " + this.getLicenseType() + ",");
        }
        if (this.getHypervisor() != null) {
            sb.append("Hypervisor: " + this.getHypervisor() + ",");
        }
        if (this.getArchitecture() != null) {
            sb.append("Architecture: " + this.getArchitecture() + ",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: " + this.getPlatform() + ",");
        }
        if (this.getClientData() != null) {
            sb.append("ClientData: " + this.getClientData() + ",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: " + this.getClientToken() + ",");
        }
        if (this.getRoleName() != null) {
            sb.append("RoleName: " + this.getRoleName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportImageRequest)) {
            return false;
        }
        ImportImageRequest other = (ImportImageRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDiskContainers() == null ^ this.getDiskContainers() == null) {
            return false;
        }
        if (other.getDiskContainers() != null && !other.getDiskContainers().equals(this.getDiskContainers())) {
            return false;
        }
        if (other.getLicenseType() == null ^ this.getLicenseType() == null) {
            return false;
        }
        if (other.getLicenseType() != null && !other.getLicenseType().equals(this.getLicenseType())) {
            return false;
        }
        if (other.getHypervisor() == null ^ this.getHypervisor() == null) {
            return false;
        }
        if (other.getHypervisor() != null && !other.getHypervisor().equals(this.getHypervisor())) {
            return false;
        }
        if (other.getArchitecture() == null ^ this.getArchitecture() == null) {
            return false;
        }
        if (other.getArchitecture() != null && !other.getArchitecture().equals(this.getArchitecture())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getClientData() == null ^ this.getClientData() == null) {
            return false;
        }
        if (other.getClientData() != null && !other.getClientData().equals(this.getClientData())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getRoleName() == null ^ this.getRoleName() == null) {
            return false;
        }
        return other.getRoleName() == null || other.getRoleName().equals(this.getRoleName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDiskContainers() == null ? 0 : this.getDiskContainers().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseType() == null ? 0 : this.getLicenseType().hashCode());
        hashCode = 31 * hashCode + (this.getHypervisor() == null ? 0 : this.getHypervisor().hashCode());
        hashCode = 31 * hashCode + (this.getArchitecture() == null ? 0 : this.getArchitecture().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getClientData() == null ? 0 : this.getClientData().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getRoleName() == null ? 0 : this.getRoleName().hashCode());
        return hashCode;
    }

    public ImportImageRequest clone() {
        return (ImportImageRequest)super.clone();
    }
}

