/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.PurchaseRequest;
import com.amazonaws.services.ec2.model.PurchaseScheduledInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class PurchaseScheduledInstancesRequestMarshaller
implements Marshaller<Request<PurchaseScheduledInstancesRequest>, PurchaseScheduledInstancesRequest> {
    public Request<PurchaseScheduledInstancesRequest> marshall(PurchaseScheduledInstancesRequest purchaseScheduledInstancesRequest) {
        if (purchaseScheduledInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)purchaseScheduledInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "PurchaseScheduledInstances");
        request.addParameter("Version", "2015-10-01");
        if (purchaseScheduledInstancesRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)purchaseScheduledInstancesRequest.getClientToken()));
        }
        List<PurchaseRequest> purchaseRequestsList = purchaseScheduledInstancesRequest.getPurchaseRequests();
        int purchaseRequestsListIndex = 1;
        for (PurchaseRequest purchaseRequestsListValue : purchaseRequestsList) {
            PurchaseRequest purchaseRequestMember = purchaseRequestsListValue;
            if (purchaseRequestMember != null) {
                if (purchaseRequestMember.getPurchaseToken() != null) {
                    request.addParameter("PurchaseRequest." + purchaseRequestsListIndex + ".PurchaseToken", StringUtils.fromString((String)purchaseRequestMember.getPurchaseToken()));
                }
                if (purchaseRequestMember.getInstanceCount() != null) {
                    request.addParameter("PurchaseRequest." + purchaseRequestsListIndex + ".InstanceCount", StringUtils.fromInteger((Integer)purchaseRequestMember.getInstanceCount()));
                }
            }
            ++purchaseRequestsListIndex;
        }
        return request;
    }
}

