/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeNatGatewaysRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeNatGatewaysRequestMarshaller
implements Marshaller<Request<DescribeNatGatewaysRequest>, DescribeNatGatewaysRequest> {
    public Request<DescribeNatGatewaysRequest> marshall(DescribeNatGatewaysRequest describeNatGatewaysRequest) {
        if (describeNatGatewaysRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeNatGatewaysRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeNatGateways");
        request.addParameter("Version", "2015-10-01");
        List<String> natGatewayIdsList = describeNatGatewaysRequest.getNatGatewayIds();
        int natGatewayIdsListIndex = 1;
        for (String natGatewayIdsListValue : natGatewayIdsList) {
            if (natGatewayIdsListValue != null) {
                request.addParameter("NatGatewayId." + natGatewayIdsListIndex, StringUtils.fromString((String)natGatewayIdsListValue));
            }
            ++natGatewayIdsListIndex;
        }
        List<Filter> filterList = describeNatGatewaysRequest.getFilter();
        int filterListIndex = 1;
        for (Filter filterListValue : filterList) {
            Filter filterMember = filterListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringUtils.fromString((String)filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filterListIndex;
        }
        if (describeNatGatewaysRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeNatGatewaysRequest.getMaxResults()));
        }
        if (describeNatGatewaysRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeNatGatewaysRequest.getNextToken()));
        }
        return request;
    }
}

