/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsyncClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.CreateBackupRequest;
import com.amazonaws.services.dynamodbv2.model.CreateBackupResult;
import com.amazonaws.services.dynamodbv2.model.CreateGlobalTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateGlobalTableResult;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DeleteBackupRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteBackupResult;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeBackupRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeBackupResult;
import com.amazonaws.services.dynamodbv2.model.DescribeContinuousBackupsRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeContinuousBackupsResult;
import com.amazonaws.services.dynamodbv2.model.DescribeContributorInsightsRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeContributorInsightsResult;
import com.amazonaws.services.dynamodbv2.model.DescribeEndpointsRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeEndpointsResult;
import com.amazonaws.services.dynamodbv2.model.DescribeExportRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeExportResult;
import com.amazonaws.services.dynamodbv2.model.DescribeGlobalTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeGlobalTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeGlobalTableSettingsRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeGlobalTableSettingsResult;
import com.amazonaws.services.dynamodbv2.model.DescribeLimitsRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeLimitsResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableReplicaAutoScalingRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableReplicaAutoScalingResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTimeToLiveRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTimeToLiveResult;
import com.amazonaws.services.dynamodbv2.model.ExportTableToPointInTimeRequest;
import com.amazonaws.services.dynamodbv2.model.ExportTableToPointInTimeResult;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.ListBackupsRequest;
import com.amazonaws.services.dynamodbv2.model.ListBackupsResult;
import com.amazonaws.services.dynamodbv2.model.ListContributorInsightsRequest;
import com.amazonaws.services.dynamodbv2.model.ListContributorInsightsResult;
import com.amazonaws.services.dynamodbv2.model.ListExportsRequest;
import com.amazonaws.services.dynamodbv2.model.ListExportsResult;
import com.amazonaws.services.dynamodbv2.model.ListGlobalTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListGlobalTablesResult;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.ListTagsOfResourceRequest;
import com.amazonaws.services.dynamodbv2.model.ListTagsOfResourceResult;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.RestoreTableFromBackupRequest;
import com.amazonaws.services.dynamodbv2.model.RestoreTableFromBackupResult;
import com.amazonaws.services.dynamodbv2.model.RestoreTableToPointInTimeRequest;
import com.amazonaws.services.dynamodbv2.model.RestoreTableToPointInTimeResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.TagResourceRequest;
import com.amazonaws.services.dynamodbv2.model.TagResourceResult;
import com.amazonaws.services.dynamodbv2.model.TransactGetItemsRequest;
import com.amazonaws.services.dynamodbv2.model.TransactGetItemsResult;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItemsRequest;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItemsResult;
import com.amazonaws.services.dynamodbv2.model.UntagResourceRequest;
import com.amazonaws.services.dynamodbv2.model.UntagResourceResult;
import com.amazonaws.services.dynamodbv2.model.UpdateContinuousBackupsRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateContinuousBackupsResult;
import com.amazonaws.services.dynamodbv2.model.UpdateContributorInsightsRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateContributorInsightsResult;
import com.amazonaws.services.dynamodbv2.model.UpdateGlobalTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateGlobalTableResult;
import com.amazonaws.services.dynamodbv2.model.UpdateGlobalTableSettingsRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateGlobalTableSettingsResult;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableReplicaAutoScalingRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableReplicaAutoScalingResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTimeToLiveRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTimeToLiveResult;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonDynamoDBAsyncClient
extends AmazonDynamoDBClient
implements AmazonDynamoDBAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonDynamoDBAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonDynamoDBAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonDynamoDBAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonDynamoDBAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonDynamoDBAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonDynamoDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonDynamoDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonDynamoDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonDynamoDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonDynamoDBAsyncClientBuilder asyncBuilder() {
        return AmazonDynamoDBAsyncClientBuilder.standard();
    }

    AmazonDynamoDBAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonDynamoDBAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(BatchGetItemRequest request) {
        return this.batchGetItemAsync(request, null);
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(BatchGetItemRequest request, final AsyncHandler<BatchGetItemRequest, BatchGetItemResult> asyncHandler) {
        final BatchGetItemRequest finalRequest = (BatchGetItemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetItemResult>(){

            @Override
            public BatchGetItemResult call() throws Exception {
                BatchGetItemResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeBatchGetItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(Map<String, KeysAndAttributes> requestItems, String returnConsumedCapacity) {
        return this.batchGetItemAsync(new BatchGetItemRequest().withRequestItems(requestItems).withReturnConsumedCapacity(returnConsumedCapacity));
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(Map<String, KeysAndAttributes> requestItems, String returnConsumedCapacity, AsyncHandler<BatchGetItemRequest, BatchGetItemResult> asyncHandler) {
        return this.batchGetItemAsync(new BatchGetItemRequest().withRequestItems(requestItems).withReturnConsumedCapacity(returnConsumedCapacity), asyncHandler);
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(Map<String, KeysAndAttributes> requestItems) {
        return this.batchGetItemAsync(new BatchGetItemRequest().withRequestItems(requestItems));
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(Map<String, KeysAndAttributes> requestItems, AsyncHandler<BatchGetItemRequest, BatchGetItemResult> asyncHandler) {
        return this.batchGetItemAsync(new BatchGetItemRequest().withRequestItems(requestItems), asyncHandler);
    }

    @Override
    public Future<BatchWriteItemResult> batchWriteItemAsync(BatchWriteItemRequest request) {
        return this.batchWriteItemAsync(request, null);
    }

    @Override
    public Future<BatchWriteItemResult> batchWriteItemAsync(BatchWriteItemRequest request, final AsyncHandler<BatchWriteItemRequest, BatchWriteItemResult> asyncHandler) {
        final BatchWriteItemRequest finalRequest = (BatchWriteItemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchWriteItemResult>(){

            @Override
            public BatchWriteItemResult call() throws Exception {
                BatchWriteItemResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeBatchWriteItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchWriteItemResult> batchWriteItemAsync(Map<String, List<WriteRequest>> requestItems) {
        return this.batchWriteItemAsync(new BatchWriteItemRequest().withRequestItems(requestItems));
    }

    @Override
    public Future<BatchWriteItemResult> batchWriteItemAsync(Map<String, List<WriteRequest>> requestItems, AsyncHandler<BatchWriteItemRequest, BatchWriteItemResult> asyncHandler) {
        return this.batchWriteItemAsync(new BatchWriteItemRequest().withRequestItems(requestItems), asyncHandler);
    }

    @Override
    public Future<CreateBackupResult> createBackupAsync(CreateBackupRequest request) {
        return this.createBackupAsync(request, null);
    }

    @Override
    public Future<CreateBackupResult> createBackupAsync(CreateBackupRequest request, final AsyncHandler<CreateBackupRequest, CreateBackupResult> asyncHandler) {
        final CreateBackupRequest finalRequest = (CreateBackupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateBackupResult>(){

            @Override
            public CreateBackupResult call() throws Exception {
                CreateBackupResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeCreateBackup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateGlobalTableResult> createGlobalTableAsync(CreateGlobalTableRequest request) {
        return this.createGlobalTableAsync(request, null);
    }

    @Override
    public Future<CreateGlobalTableResult> createGlobalTableAsync(CreateGlobalTableRequest request, final AsyncHandler<CreateGlobalTableRequest, CreateGlobalTableResult> asyncHandler) {
        final CreateGlobalTableRequest finalRequest = (CreateGlobalTableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateGlobalTableResult>(){

            @Override
            public CreateGlobalTableResult call() throws Exception {
                CreateGlobalTableResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeCreateGlobalTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTableResult> createTableAsync(CreateTableRequest request) {
        return this.createTableAsync(request, null);
    }

    @Override
    public Future<CreateTableResult> createTableAsync(CreateTableRequest request, final AsyncHandler<CreateTableRequest, CreateTableResult> asyncHandler) {
        final CreateTableRequest finalRequest = (CreateTableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTableResult>(){

            @Override
            public CreateTableResult call() throws Exception {
                CreateTableResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeCreateTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTableResult> createTableAsync(List<AttributeDefinition> attributeDefinitions, String tableName, List<KeySchemaElement> keySchema, ProvisionedThroughput provisionedThroughput) {
        return this.createTableAsync(new CreateTableRequest().withAttributeDefinitions(attributeDefinitions).withTableName(tableName).withKeySchema(keySchema).withProvisionedThroughput(provisionedThroughput));
    }

    @Override
    public Future<CreateTableResult> createTableAsync(List<AttributeDefinition> attributeDefinitions, String tableName, List<KeySchemaElement> keySchema, ProvisionedThroughput provisionedThroughput, AsyncHandler<CreateTableRequest, CreateTableResult> asyncHandler) {
        return this.createTableAsync(new CreateTableRequest().withAttributeDefinitions(attributeDefinitions).withTableName(tableName).withKeySchema(keySchema).withProvisionedThroughput(provisionedThroughput), asyncHandler);
    }

    @Override
    public Future<DeleteBackupResult> deleteBackupAsync(DeleteBackupRequest request) {
        return this.deleteBackupAsync(request, null);
    }

    @Override
    public Future<DeleteBackupResult> deleteBackupAsync(DeleteBackupRequest request, final AsyncHandler<DeleteBackupRequest, DeleteBackupResult> asyncHandler) {
        final DeleteBackupRequest finalRequest = (DeleteBackupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteBackupResult>(){

            @Override
            public DeleteBackupResult call() throws Exception {
                DeleteBackupResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeDeleteBackup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(DeleteItemRequest request) {
        return this.deleteItemAsync(request, null);
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(DeleteItemRequest request, final AsyncHandler<DeleteItemRequest, DeleteItemResult> asyncHandler) {
        final DeleteItemRequest finalRequest = (DeleteItemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteItemResult>(){

            @Override
            public DeleteItemResult call() throws Exception {
                DeleteItemResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeDeleteItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(String tableName, Map<String, AttributeValue> key) {
        return this.deleteItemAsync(new DeleteItemRequest().withTableName(tableName).withKey(key));
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(String tableName, Map<String, AttributeValue> key, AsyncHandler<DeleteItemRequest, DeleteItemResult> asyncHandler) {
        return this.deleteItemAsync(new DeleteItemRequest().withTableName(tableName).withKey(key), asyncHandler);
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(String tableName, Map<String, AttributeValue> key, String returnValues) {
        return this.deleteItemAsync(new DeleteItemRequest().withTableName(tableName).withKey(key).withReturnValues(returnValues));
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(String tableName, Map<String, AttributeValue> key, String returnValues, AsyncHandler<DeleteItemRequest, DeleteItemResult> asyncHandler) {
        return this.deleteItemAsync(new DeleteItemRequest().withTableName(tableName).withKey(key).withReturnValues(returnValues), asyncHandler);
    }

    @Override
    public Future<DeleteTableResult> deleteTableAsync(DeleteTableRequest request) {
        return this.deleteTableAsync(request, null);
    }

    @Override
    public Future<DeleteTableResult> deleteTableAsync(DeleteTableRequest request, final AsyncHandler<DeleteTableRequest, DeleteTableResult> asyncHandler) {
        final DeleteTableRequest finalRequest = (DeleteTableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTableResult>(){

            @Override
            public DeleteTableResult call() throws Exception {
                DeleteTableResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeDeleteTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTableResult> deleteTableAsync(String tableName) {
        return this.deleteTableAsync(new DeleteTableRequest().withTableName(tableName));
    }

    @Override
    public Future<DeleteTableResult> deleteTableAsync(String tableName, AsyncHandler<DeleteTableRequest, DeleteTableResult> asyncHandler) {
        return this.deleteTableAsync(new DeleteTableRequest().withTableName(tableName), asyncHandler);
    }

    @Override
    public Future<DescribeBackupResult> describeBackupAsync(DescribeBackupRequest request) {
        return this.describeBackupAsync(request, null);
    }

    @Override
    public Future<DescribeBackupResult> describeBackupAsync(DescribeBackupRequest request, final AsyncHandler<DescribeBackupRequest, DescribeBackupResult> asyncHandler) {
        final DescribeBackupRequest finalRequest = (DescribeBackupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeBackupResult>(){

            @Override
            public DescribeBackupResult call() throws Exception {
                DescribeBackupResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeDescribeBackup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeContinuousBackupsResult> describeContinuousBackupsAsync(DescribeContinuousBackupsRequest request) {
        return this.describeContinuousBackupsAsync(request, null);
    }

    @Override
    public Future<DescribeContinuousBackupsResult> describeContinuousBackupsAsync(DescribeContinuousBackupsRequest request, final AsyncHandler<DescribeContinuousBackupsRequest, DescribeContinuousBackupsResult> asyncHandler) {
        final DescribeContinuousBackupsRequest finalRequest = (DescribeContinuousBackupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeContinuousBackupsResult>(){

            @Override
            public DescribeContinuousBackupsResult call() throws Exception {
                DescribeContinuousBackupsResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeDescribeContinuousBackups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeContributorInsightsResult> describeContributorInsightsAsync(DescribeContributorInsightsRequest request) {
        return this.describeContributorInsightsAsync(request, null);
    }

    @Override
    public Future<DescribeContributorInsightsResult> describeContributorInsightsAsync(DescribeContributorInsightsRequest request, final AsyncHandler<DescribeContributorInsightsRequest, DescribeContributorInsightsResult> asyncHandler) {
        final DescribeContributorInsightsRequest finalRequest = (DescribeContributorInsightsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeContributorInsightsResult>(){

            @Override
            public DescribeContributorInsightsResult call() throws Exception {
                DescribeContributorInsightsResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeDescribeContributorInsights(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEndpointsResult> describeEndpointsAsync(DescribeEndpointsRequest request) {
        return this.describeEndpointsAsync(request, null);
    }

    @Override
    public Future<DescribeEndpointsResult> describeEndpointsAsync(DescribeEndpointsRequest request, final AsyncHandler<DescribeEndpointsRequest, DescribeEndpointsResult> asyncHandler) {
        final DescribeEndpointsRequest finalRequest = (DescribeEndpointsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEndpointsResult>(){

            @Override
            public DescribeEndpointsResult call() throws Exception {
                DescribeEndpointsResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeDescribeEndpoints(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeExportResult> describeExportAsync(DescribeExportRequest request) {
        return this.describeExportAsync(request, null);
    }

    @Override
    public Future<DescribeExportResult> describeExportAsync(DescribeExportRequest request, final AsyncHandler<DescribeExportRequest, DescribeExportResult> asyncHandler) {
        final DescribeExportRequest finalRequest = (DescribeExportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeExportResult>(){

            @Override
            public DescribeExportResult call() throws Exception {
                DescribeExportResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeDescribeExport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeGlobalTableResult> describeGlobalTableAsync(DescribeGlobalTableRequest request) {
        return this.describeGlobalTableAsync(request, null);
    }

    @Override
    public Future<DescribeGlobalTableResult> describeGlobalTableAsync(DescribeGlobalTableRequest request, final AsyncHandler<DescribeGlobalTableRequest, DescribeGlobalTableResult> asyncHandler) {
        final DescribeGlobalTableRequest finalRequest = (DescribeGlobalTableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeGlobalTableResult>(){

            @Override
            public DescribeGlobalTableResult call() throws Exception {
                DescribeGlobalTableResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeDescribeGlobalTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeGlobalTableSettingsResult> describeGlobalTableSettingsAsync(DescribeGlobalTableSettingsRequest request) {
        return this.describeGlobalTableSettingsAsync(request, null);
    }

    @Override
    public Future<DescribeGlobalTableSettingsResult> describeGlobalTableSettingsAsync(DescribeGlobalTableSettingsRequest request, final AsyncHandler<DescribeGlobalTableSettingsRequest, DescribeGlobalTableSettingsResult> asyncHandler) {
        final DescribeGlobalTableSettingsRequest finalRequest = (DescribeGlobalTableSettingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeGlobalTableSettingsResult>(){

            @Override
            public DescribeGlobalTableSettingsResult call() throws Exception {
                DescribeGlobalTableSettingsResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeDescribeGlobalTableSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLimitsResult> describeLimitsAsync(DescribeLimitsRequest request) {
        return this.describeLimitsAsync(request, null);
    }

    @Override
    public Future<DescribeLimitsResult> describeLimitsAsync(DescribeLimitsRequest request, final AsyncHandler<DescribeLimitsRequest, DescribeLimitsResult> asyncHandler) {
        final DescribeLimitsRequest finalRequest = (DescribeLimitsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeLimitsResult>(){

            @Override
            public DescribeLimitsResult call() throws Exception {
                DescribeLimitsResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeDescribeLimits(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTableResult> describeTableAsync(DescribeTableRequest request) {
        return this.describeTableAsync(request, null);
    }

    @Override
    public Future<DescribeTableResult> describeTableAsync(DescribeTableRequest request, final AsyncHandler<DescribeTableRequest, DescribeTableResult> asyncHandler) {
        final DescribeTableRequest finalRequest = (DescribeTableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTableResult>(){

            @Override
            public DescribeTableResult call() throws Exception {
                DescribeTableResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeDescribeTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTableResult> describeTableAsync(String tableName) {
        return this.describeTableAsync(new DescribeTableRequest().withTableName(tableName));
    }

    @Override
    public Future<DescribeTableResult> describeTableAsync(String tableName, AsyncHandler<DescribeTableRequest, DescribeTableResult> asyncHandler) {
        return this.describeTableAsync(new DescribeTableRequest().withTableName(tableName), asyncHandler);
    }

    @Override
    public Future<DescribeTableReplicaAutoScalingResult> describeTableReplicaAutoScalingAsync(DescribeTableReplicaAutoScalingRequest request) {
        return this.describeTableReplicaAutoScalingAsync(request, null);
    }

    @Override
    public Future<DescribeTableReplicaAutoScalingResult> describeTableReplicaAutoScalingAsync(DescribeTableReplicaAutoScalingRequest request, final AsyncHandler<DescribeTableReplicaAutoScalingRequest, DescribeTableReplicaAutoScalingResult> asyncHandler) {
        final DescribeTableReplicaAutoScalingRequest finalRequest = (DescribeTableReplicaAutoScalingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTableReplicaAutoScalingResult>(){

            @Override
            public DescribeTableReplicaAutoScalingResult call() throws Exception {
                DescribeTableReplicaAutoScalingResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeDescribeTableReplicaAutoScaling(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTimeToLiveResult> describeTimeToLiveAsync(DescribeTimeToLiveRequest request) {
        return this.describeTimeToLiveAsync(request, null);
    }

    @Override
    public Future<DescribeTimeToLiveResult> describeTimeToLiveAsync(DescribeTimeToLiveRequest request, final AsyncHandler<DescribeTimeToLiveRequest, DescribeTimeToLiveResult> asyncHandler) {
        final DescribeTimeToLiveRequest finalRequest = (DescribeTimeToLiveRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTimeToLiveResult>(){

            @Override
            public DescribeTimeToLiveResult call() throws Exception {
                DescribeTimeToLiveResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeDescribeTimeToLive(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExportTableToPointInTimeResult> exportTableToPointInTimeAsync(ExportTableToPointInTimeRequest request) {
        return this.exportTableToPointInTimeAsync(request, null);
    }

    @Override
    public Future<ExportTableToPointInTimeResult> exportTableToPointInTimeAsync(ExportTableToPointInTimeRequest request, final AsyncHandler<ExportTableToPointInTimeRequest, ExportTableToPointInTimeResult> asyncHandler) {
        final ExportTableToPointInTimeRequest finalRequest = (ExportTableToPointInTimeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExportTableToPointInTimeResult>(){

            @Override
            public ExportTableToPointInTimeResult call() throws Exception {
                ExportTableToPointInTimeResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeExportTableToPointInTime(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetItemResult> getItemAsync(GetItemRequest request) {
        return this.getItemAsync(request, null);
    }

    @Override
    public Future<GetItemResult> getItemAsync(GetItemRequest request, final AsyncHandler<GetItemRequest, GetItemResult> asyncHandler) {
        final GetItemRequest finalRequest = (GetItemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetItemResult>(){

            @Override
            public GetItemResult call() throws Exception {
                GetItemResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeGetItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetItemResult> getItemAsync(String tableName, Map<String, AttributeValue> key) {
        return this.getItemAsync(new GetItemRequest().withTableName(tableName).withKey(key));
    }

    @Override
    public Future<GetItemResult> getItemAsync(String tableName, Map<String, AttributeValue> key, AsyncHandler<GetItemRequest, GetItemResult> asyncHandler) {
        return this.getItemAsync(new GetItemRequest().withTableName(tableName).withKey(key), asyncHandler);
    }

    @Override
    public Future<GetItemResult> getItemAsync(String tableName, Map<String, AttributeValue> key, Boolean consistentRead) {
        return this.getItemAsync(new GetItemRequest().withTableName(tableName).withKey(key).withConsistentRead(consistentRead));
    }

    @Override
    public Future<GetItemResult> getItemAsync(String tableName, Map<String, AttributeValue> key, Boolean consistentRead, AsyncHandler<GetItemRequest, GetItemResult> asyncHandler) {
        return this.getItemAsync(new GetItemRequest().withTableName(tableName).withKey(key).withConsistentRead(consistentRead), asyncHandler);
    }

    @Override
    public Future<ListBackupsResult> listBackupsAsync(ListBackupsRequest request) {
        return this.listBackupsAsync(request, null);
    }

    @Override
    public Future<ListBackupsResult> listBackupsAsync(ListBackupsRequest request, final AsyncHandler<ListBackupsRequest, ListBackupsResult> asyncHandler) {
        final ListBackupsRequest finalRequest = (ListBackupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListBackupsResult>(){

            @Override
            public ListBackupsResult call() throws Exception {
                ListBackupsResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeListBackups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListContributorInsightsResult> listContributorInsightsAsync(ListContributorInsightsRequest request) {
        return this.listContributorInsightsAsync(request, null);
    }

    @Override
    public Future<ListContributorInsightsResult> listContributorInsightsAsync(ListContributorInsightsRequest request, final AsyncHandler<ListContributorInsightsRequest, ListContributorInsightsResult> asyncHandler) {
        final ListContributorInsightsRequest finalRequest = (ListContributorInsightsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListContributorInsightsResult>(){

            @Override
            public ListContributorInsightsResult call() throws Exception {
                ListContributorInsightsResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeListContributorInsights(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListExportsResult> listExportsAsync(ListExportsRequest request) {
        return this.listExportsAsync(request, null);
    }

    @Override
    public Future<ListExportsResult> listExportsAsync(ListExportsRequest request, final AsyncHandler<ListExportsRequest, ListExportsResult> asyncHandler) {
        final ListExportsRequest finalRequest = (ListExportsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListExportsResult>(){

            @Override
            public ListExportsResult call() throws Exception {
                ListExportsResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeListExports(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGlobalTablesResult> listGlobalTablesAsync(ListGlobalTablesRequest request) {
        return this.listGlobalTablesAsync(request, null);
    }

    @Override
    public Future<ListGlobalTablesResult> listGlobalTablesAsync(ListGlobalTablesRequest request, final AsyncHandler<ListGlobalTablesRequest, ListGlobalTablesResult> asyncHandler) {
        final ListGlobalTablesRequest finalRequest = (ListGlobalTablesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGlobalTablesResult>(){

            @Override
            public ListGlobalTablesResult call() throws Exception {
                ListGlobalTablesResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeListGlobalTables(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(ListTablesRequest request) {
        return this.listTablesAsync(request, null);
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(ListTablesRequest request, final AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        final ListTablesRequest finalRequest = (ListTablesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTablesResult>(){

            @Override
            public ListTablesResult call() throws Exception {
                ListTablesResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeListTables(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTablesResult> listTablesAsync() {
        return this.listTablesAsync(new ListTablesRequest());
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        return this.listTablesAsync(new ListTablesRequest(), asyncHandler);
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(String exclusiveStartTableName) {
        return this.listTablesAsync(new ListTablesRequest().withExclusiveStartTableName(exclusiveStartTableName));
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(String exclusiveStartTableName, AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        return this.listTablesAsync(new ListTablesRequest().withExclusiveStartTableName(exclusiveStartTableName), asyncHandler);
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(String exclusiveStartTableName, Integer limit) {
        return this.listTablesAsync(new ListTablesRequest().withExclusiveStartTableName(exclusiveStartTableName).withLimit(limit));
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(String exclusiveStartTableName, Integer limit, AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        return this.listTablesAsync(new ListTablesRequest().withExclusiveStartTableName(exclusiveStartTableName).withLimit(limit), asyncHandler);
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(Integer limit) {
        return this.listTablesAsync(new ListTablesRequest().withLimit(limit));
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(Integer limit, AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        return this.listTablesAsync(new ListTablesRequest().withLimit(limit), asyncHandler);
    }

    @Override
    public Future<ListTagsOfResourceResult> listTagsOfResourceAsync(ListTagsOfResourceRequest request) {
        return this.listTagsOfResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsOfResourceResult> listTagsOfResourceAsync(ListTagsOfResourceRequest request, final AsyncHandler<ListTagsOfResourceRequest, ListTagsOfResourceResult> asyncHandler) {
        final ListTagsOfResourceRequest finalRequest = (ListTagsOfResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsOfResourceResult>(){

            @Override
            public ListTagsOfResourceResult call() throws Exception {
                ListTagsOfResourceResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeListTagsOfResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutItemResult> putItemAsync(PutItemRequest request) {
        return this.putItemAsync(request, null);
    }

    @Override
    public Future<PutItemResult> putItemAsync(PutItemRequest request, final AsyncHandler<PutItemRequest, PutItemResult> asyncHandler) {
        final PutItemRequest finalRequest = (PutItemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutItemResult>(){

            @Override
            public PutItemResult call() throws Exception {
                PutItemResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executePutItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutItemResult> putItemAsync(String tableName, Map<String, AttributeValue> item) {
        return this.putItemAsync(new PutItemRequest().withTableName(tableName).withItem(item));
    }

    @Override
    public Future<PutItemResult> putItemAsync(String tableName, Map<String, AttributeValue> item, AsyncHandler<PutItemRequest, PutItemResult> asyncHandler) {
        return this.putItemAsync(new PutItemRequest().withTableName(tableName).withItem(item), asyncHandler);
    }

    @Override
    public Future<PutItemResult> putItemAsync(String tableName, Map<String, AttributeValue> item, String returnValues) {
        return this.putItemAsync(new PutItemRequest().withTableName(tableName).withItem(item).withReturnValues(returnValues));
    }

    @Override
    public Future<PutItemResult> putItemAsync(String tableName, Map<String, AttributeValue> item, String returnValues, AsyncHandler<PutItemRequest, PutItemResult> asyncHandler) {
        return this.putItemAsync(new PutItemRequest().withTableName(tableName).withItem(item).withReturnValues(returnValues), asyncHandler);
    }

    @Override
    public Future<QueryResult> queryAsync(QueryRequest request) {
        return this.queryAsync(request, null);
    }

    @Override
    public Future<QueryResult> queryAsync(QueryRequest request, final AsyncHandler<QueryRequest, QueryResult> asyncHandler) {
        final QueryRequest finalRequest = (QueryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<QueryResult>(){

            @Override
            public QueryResult call() throws Exception {
                QueryResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RestoreTableFromBackupResult> restoreTableFromBackupAsync(RestoreTableFromBackupRequest request) {
        return this.restoreTableFromBackupAsync(request, null);
    }

    @Override
    public Future<RestoreTableFromBackupResult> restoreTableFromBackupAsync(RestoreTableFromBackupRequest request, final AsyncHandler<RestoreTableFromBackupRequest, RestoreTableFromBackupResult> asyncHandler) {
        final RestoreTableFromBackupRequest finalRequest = (RestoreTableFromBackupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RestoreTableFromBackupResult>(){

            @Override
            public RestoreTableFromBackupResult call() throws Exception {
                RestoreTableFromBackupResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeRestoreTableFromBackup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RestoreTableToPointInTimeResult> restoreTableToPointInTimeAsync(RestoreTableToPointInTimeRequest request) {
        return this.restoreTableToPointInTimeAsync(request, null);
    }

    @Override
    public Future<RestoreTableToPointInTimeResult> restoreTableToPointInTimeAsync(RestoreTableToPointInTimeRequest request, final AsyncHandler<RestoreTableToPointInTimeRequest, RestoreTableToPointInTimeResult> asyncHandler) {
        final RestoreTableToPointInTimeRequest finalRequest = (RestoreTableToPointInTimeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RestoreTableToPointInTimeResult>(){

            @Override
            public RestoreTableToPointInTimeResult call() throws Exception {
                RestoreTableToPointInTimeResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeRestoreTableToPointInTime(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ScanResult> scanAsync(ScanRequest request) {
        return this.scanAsync(request, null);
    }

    @Override
    public Future<ScanResult> scanAsync(ScanRequest request, final AsyncHandler<ScanRequest, ScanResult> asyncHandler) {
        final ScanRequest finalRequest = (ScanRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ScanResult>(){

            @Override
            public ScanResult call() throws Exception {
                ScanResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeScan(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ScanResult> scanAsync(String tableName, List<String> attributesToGet) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withAttributesToGet(attributesToGet));
    }

    @Override
    public Future<ScanResult> scanAsync(String tableName, List<String> attributesToGet, AsyncHandler<ScanRequest, ScanResult> asyncHandler) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withAttributesToGet(attributesToGet), asyncHandler);
    }

    @Override
    public Future<ScanResult> scanAsync(String tableName, Map<String, Condition> scanFilter) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withScanFilter(scanFilter));
    }

    @Override
    public Future<ScanResult> scanAsync(String tableName, Map<String, Condition> scanFilter, AsyncHandler<ScanRequest, ScanResult> asyncHandler) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withScanFilter(scanFilter), asyncHandler);
    }

    @Override
    public Future<ScanResult> scanAsync(String tableName, List<String> attributesToGet, Map<String, Condition> scanFilter) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withAttributesToGet(attributesToGet).withScanFilter(scanFilter));
    }

    @Override
    public Future<ScanResult> scanAsync(String tableName, List<String> attributesToGet, Map<String, Condition> scanFilter, AsyncHandler<ScanRequest, ScanResult> asyncHandler) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withAttributesToGet(attributesToGet).withScanFilter(scanFilter), asyncHandler);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TransactGetItemsResult> transactGetItemsAsync(TransactGetItemsRequest request) {
        return this.transactGetItemsAsync(request, null);
    }

    @Override
    public Future<TransactGetItemsResult> transactGetItemsAsync(TransactGetItemsRequest request, final AsyncHandler<TransactGetItemsRequest, TransactGetItemsResult> asyncHandler) {
        final TransactGetItemsRequest finalRequest = (TransactGetItemsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TransactGetItemsResult>(){

            @Override
            public TransactGetItemsResult call() throws Exception {
                TransactGetItemsResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeTransactGetItems(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TransactWriteItemsResult> transactWriteItemsAsync(TransactWriteItemsRequest request) {
        return this.transactWriteItemsAsync(request, null);
    }

    @Override
    public Future<TransactWriteItemsResult> transactWriteItemsAsync(TransactWriteItemsRequest request, final AsyncHandler<TransactWriteItemsRequest, TransactWriteItemsResult> asyncHandler) {
        final TransactWriteItemsRequest finalRequest = (TransactWriteItemsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TransactWriteItemsResult>(){

            @Override
            public TransactWriteItemsResult call() throws Exception {
                TransactWriteItemsResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeTransactWriteItems(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateContinuousBackupsResult> updateContinuousBackupsAsync(UpdateContinuousBackupsRequest request) {
        return this.updateContinuousBackupsAsync(request, null);
    }

    @Override
    public Future<UpdateContinuousBackupsResult> updateContinuousBackupsAsync(UpdateContinuousBackupsRequest request, final AsyncHandler<UpdateContinuousBackupsRequest, UpdateContinuousBackupsResult> asyncHandler) {
        final UpdateContinuousBackupsRequest finalRequest = (UpdateContinuousBackupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateContinuousBackupsResult>(){

            @Override
            public UpdateContinuousBackupsResult call() throws Exception {
                UpdateContinuousBackupsResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeUpdateContinuousBackups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateContributorInsightsResult> updateContributorInsightsAsync(UpdateContributorInsightsRequest request) {
        return this.updateContributorInsightsAsync(request, null);
    }

    @Override
    public Future<UpdateContributorInsightsResult> updateContributorInsightsAsync(UpdateContributorInsightsRequest request, final AsyncHandler<UpdateContributorInsightsRequest, UpdateContributorInsightsResult> asyncHandler) {
        final UpdateContributorInsightsRequest finalRequest = (UpdateContributorInsightsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateContributorInsightsResult>(){

            @Override
            public UpdateContributorInsightsResult call() throws Exception {
                UpdateContributorInsightsResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeUpdateContributorInsights(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateGlobalTableResult> updateGlobalTableAsync(UpdateGlobalTableRequest request) {
        return this.updateGlobalTableAsync(request, null);
    }

    @Override
    public Future<UpdateGlobalTableResult> updateGlobalTableAsync(UpdateGlobalTableRequest request, final AsyncHandler<UpdateGlobalTableRequest, UpdateGlobalTableResult> asyncHandler) {
        final UpdateGlobalTableRequest finalRequest = (UpdateGlobalTableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateGlobalTableResult>(){

            @Override
            public UpdateGlobalTableResult call() throws Exception {
                UpdateGlobalTableResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeUpdateGlobalTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateGlobalTableSettingsResult> updateGlobalTableSettingsAsync(UpdateGlobalTableSettingsRequest request) {
        return this.updateGlobalTableSettingsAsync(request, null);
    }

    @Override
    public Future<UpdateGlobalTableSettingsResult> updateGlobalTableSettingsAsync(UpdateGlobalTableSettingsRequest request, final AsyncHandler<UpdateGlobalTableSettingsRequest, UpdateGlobalTableSettingsResult> asyncHandler) {
        final UpdateGlobalTableSettingsRequest finalRequest = (UpdateGlobalTableSettingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateGlobalTableSettingsResult>(){

            @Override
            public UpdateGlobalTableSettingsResult call() throws Exception {
                UpdateGlobalTableSettingsResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeUpdateGlobalTableSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(UpdateItemRequest request) {
        return this.updateItemAsync(request, null);
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(UpdateItemRequest request, final AsyncHandler<UpdateItemRequest, UpdateItemResult> asyncHandler) {
        final UpdateItemRequest finalRequest = (UpdateItemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateItemResult>(){

            @Override
            public UpdateItemResult call() throws Exception {
                UpdateItemResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeUpdateItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates) {
        return this.updateItemAsync(new UpdateItemRequest().withTableName(tableName).withKey(key).withAttributeUpdates(attributeUpdates));
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates, AsyncHandler<UpdateItemRequest, UpdateItemResult> asyncHandler) {
        return this.updateItemAsync(new UpdateItemRequest().withTableName(tableName).withKey(key).withAttributeUpdates(attributeUpdates), asyncHandler);
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates, String returnValues) {
        return this.updateItemAsync(new UpdateItemRequest().withTableName(tableName).withKey(key).withAttributeUpdates(attributeUpdates).withReturnValues(returnValues));
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates, String returnValues, AsyncHandler<UpdateItemRequest, UpdateItemResult> asyncHandler) {
        return this.updateItemAsync(new UpdateItemRequest().withTableName(tableName).withKey(key).withAttributeUpdates(attributeUpdates).withReturnValues(returnValues), asyncHandler);
    }

    @Override
    public Future<UpdateTableResult> updateTableAsync(UpdateTableRequest request) {
        return this.updateTableAsync(request, null);
    }

    @Override
    public Future<UpdateTableResult> updateTableAsync(UpdateTableRequest request, final AsyncHandler<UpdateTableRequest, UpdateTableResult> asyncHandler) {
        final UpdateTableRequest finalRequest = (UpdateTableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateTableResult>(){

            @Override
            public UpdateTableResult call() throws Exception {
                UpdateTableResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeUpdateTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTableResult> updateTableAsync(String tableName, ProvisionedThroughput provisionedThroughput) {
        return this.updateTableAsync(new UpdateTableRequest().withTableName(tableName).withProvisionedThroughput(provisionedThroughput));
    }

    @Override
    public Future<UpdateTableResult> updateTableAsync(String tableName, ProvisionedThroughput provisionedThroughput, AsyncHandler<UpdateTableRequest, UpdateTableResult> asyncHandler) {
        return this.updateTableAsync(new UpdateTableRequest().withTableName(tableName).withProvisionedThroughput(provisionedThroughput), asyncHandler);
    }

    @Override
    public Future<UpdateTableReplicaAutoScalingResult> updateTableReplicaAutoScalingAsync(UpdateTableReplicaAutoScalingRequest request) {
        return this.updateTableReplicaAutoScalingAsync(request, null);
    }

    @Override
    public Future<UpdateTableReplicaAutoScalingResult> updateTableReplicaAutoScalingAsync(UpdateTableReplicaAutoScalingRequest request, final AsyncHandler<UpdateTableReplicaAutoScalingRequest, UpdateTableReplicaAutoScalingResult> asyncHandler) {
        final UpdateTableReplicaAutoScalingRequest finalRequest = (UpdateTableReplicaAutoScalingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateTableReplicaAutoScalingResult>(){

            @Override
            public UpdateTableReplicaAutoScalingResult call() throws Exception {
                UpdateTableReplicaAutoScalingResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeUpdateTableReplicaAutoScaling(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTimeToLiveResult> updateTimeToLiveAsync(UpdateTimeToLiveRequest request) {
        return this.updateTimeToLiveAsync(request, null);
    }

    @Override
    public Future<UpdateTimeToLiveResult> updateTimeToLiveAsync(UpdateTimeToLiveRequest request, final AsyncHandler<UpdateTimeToLiveRequest, UpdateTimeToLiveResult> asyncHandler) {
        final UpdateTimeToLiveRequest finalRequest = (UpdateTimeToLiveRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateTimeToLiveResult>(){

            @Override
            public UpdateTimeToLiveResult call() throws Exception {
                UpdateTimeToLiveResult result = null;
                try {
                    result = AmazonDynamoDBAsyncClient.this.executeUpdateTimeToLive(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

