/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;
import java.util.Map;

public class KeysAndAttributesJsonMarshaller {
    private static KeysAndAttributesJsonMarshaller instance;

    public void marshall(KeysAndAttributes keysAndAttributes, JSONWriter jsonWriter) {
        if (keysAndAttributes == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> expressionAttributeNamesMap;
            List<String> attributesToGetList;
            jsonWriter.object();
            List<Map<String, AttributeValue>> keysList = keysAndAttributes.getKeys();
            if (keysList != null) {
                jsonWriter.key("Keys");
                jsonWriter.array();
                for (Map<String, AttributeValue> keysListValue : keysList) {
                    if (keysListValue == null) continue;
                    jsonWriter.object();
                    for (Map.Entry<String, Object> entry : keysListValue.entrySet()) {
                        if (entry.getValue() == null) continue;
                        jsonWriter.key(entry.getKey());
                        AttributeValueJsonMarshaller.getInstance().marshall((AttributeValue)entry.getValue(), jsonWriter);
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if ((attributesToGetList = keysAndAttributes.getAttributesToGet()) != null) {
                jsonWriter.key("AttributesToGet");
                jsonWriter.array();
                for (String attributesToGetListValue : attributesToGetList) {
                    if (attributesToGetListValue == null) continue;
                    jsonWriter.value((Object)attributesToGetListValue);
                }
                jsonWriter.endArray();
            }
            if (keysAndAttributes.getConsistentRead() != null) {
                jsonWriter.key("ConsistentRead").value((Object)keysAndAttributes.getConsistentRead());
            }
            if (keysAndAttributes.getProjectionExpression() != null) {
                jsonWriter.key("ProjectionExpression").value((Object)keysAndAttributes.getProjectionExpression());
            }
            if ((expressionAttributeNamesMap = keysAndAttributes.getExpressionAttributeNames()) != null) {
                jsonWriter.key("ExpressionAttributeNames");
                jsonWriter.object();
                for (Map.Entry<String, Object> entry : expressionAttributeNamesMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.key(entry.getKey());
                    jsonWriter.value(entry.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static KeysAndAttributesJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new KeysAndAttributesJsonMarshaller();
        }
        return instance;
    }
}

