/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.drs.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.drs.model.LaunchAction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListLaunchActionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<LaunchAction> items;
    private String nextToken;

    public List<LaunchAction> getItems() {
        return this.items;
    }

    public void setItems(Collection<LaunchAction> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        this.items = new ArrayList<LaunchAction>(items);
    }

    public ListLaunchActionsResult withItems(LaunchAction ... items) {
        if (this.items == null) {
            this.setItems(new ArrayList<LaunchAction>(items.length));
        }
        for (LaunchAction ele : items) {
            this.items.add(ele);
        }
        return this;
    }

    public ListLaunchActionsResult withItems(Collection<LaunchAction> items) {
        this.setItems(items);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListLaunchActionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getItems() != null) {
            sb.append("Items: ").append(this.getItems()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLaunchActionsResult)) {
            return false;
        }
        ListLaunchActionsResult other = (ListLaunchActionsResult)obj;
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        if (other.getItems() != null && !other.getItems().equals(this.getItems())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : this.getItems().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListLaunchActionsResult clone() {
        try {
            return (ListLaunchActionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

