/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.drs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.drs.model.LaunchAction;
import java.util.Map;

@SdkInternalApi
public class LaunchActionMarshaller {
    private static final MarshallingInfo<String> ACTIONCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionCode").build();
    private static final MarshallingInfo<String> ACTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionId").build();
    private static final MarshallingInfo<String> ACTIONVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionVersion").build();
    private static final MarshallingInfo<Boolean> ACTIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("active").build();
    private static final MarshallingInfo<String> CATEGORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("category").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<Boolean> OPTIONAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("optional").build();
    private static final MarshallingInfo<Integer> ORDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("order").build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parameters").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final LaunchActionMarshaller instance = new LaunchActionMarshaller();

    public static LaunchActionMarshaller getInstance() {
        return instance;
    }

    public void marshall(LaunchAction launchAction, ProtocolMarshaller protocolMarshaller) {
        if (launchAction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)launchAction.getActionCode(), ACTIONCODE_BINDING);
            protocolMarshaller.marshall((Object)launchAction.getActionId(), ACTIONID_BINDING);
            protocolMarshaller.marshall((Object)launchAction.getActionVersion(), ACTIONVERSION_BINDING);
            protocolMarshaller.marshall((Object)launchAction.getActive(), ACTIVE_BINDING);
            protocolMarshaller.marshall((Object)launchAction.getCategory(), CATEGORY_BINDING);
            protocolMarshaller.marshall((Object)launchAction.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)launchAction.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)launchAction.getOptional(), OPTIONAL_BINDING);
            protocolMarshaller.marshall((Object)launchAction.getOrder(), ORDER_BINDING);
            protocolMarshaller.marshall(launchAction.getParameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)launchAction.getType(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

