/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.drs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.drs.model.transform.ConversionPropertiesMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ConversionProperties
implements Serializable,
Cloneable,
StructuredPojo {
    private String dataTimestamp;
    private Boolean forceUefi;
    private String rootVolumeName;
    private Map<String, Map<String, String>> volumeToConversionMap;
    private Map<String, Long> volumeToVolumeSize;

    public void setDataTimestamp(String dataTimestamp) {
        this.dataTimestamp = dataTimestamp;
    }

    public String getDataTimestamp() {
        return this.dataTimestamp;
    }

    public ConversionProperties withDataTimestamp(String dataTimestamp) {
        this.setDataTimestamp(dataTimestamp);
        return this;
    }

    public void setForceUefi(Boolean forceUefi) {
        this.forceUefi = forceUefi;
    }

    public Boolean getForceUefi() {
        return this.forceUefi;
    }

    public ConversionProperties withForceUefi(Boolean forceUefi) {
        this.setForceUefi(forceUefi);
        return this;
    }

    public Boolean isForceUefi() {
        return this.forceUefi;
    }

    public void setRootVolumeName(String rootVolumeName) {
        this.rootVolumeName = rootVolumeName;
    }

    public String getRootVolumeName() {
        return this.rootVolumeName;
    }

    public ConversionProperties withRootVolumeName(String rootVolumeName) {
        this.setRootVolumeName(rootVolumeName);
        return this;
    }

    public Map<String, Map<String, String>> getVolumeToConversionMap() {
        return this.volumeToConversionMap;
    }

    public void setVolumeToConversionMap(Map<String, Map<String, String>> volumeToConversionMap) {
        this.volumeToConversionMap = volumeToConversionMap;
    }

    public ConversionProperties withVolumeToConversionMap(Map<String, Map<String, String>> volumeToConversionMap) {
        this.setVolumeToConversionMap(volumeToConversionMap);
        return this;
    }

    public ConversionProperties addVolumeToConversionMapEntry(String key, Map<String, String> value) {
        if (null == this.volumeToConversionMap) {
            this.volumeToConversionMap = new HashMap<String, Map<String, String>>();
        }
        if (this.volumeToConversionMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.volumeToConversionMap.put(key, value);
        return this;
    }

    public ConversionProperties clearVolumeToConversionMapEntries() {
        this.volumeToConversionMap = null;
        return this;
    }

    public Map<String, Long> getVolumeToVolumeSize() {
        return this.volumeToVolumeSize;
    }

    public void setVolumeToVolumeSize(Map<String, Long> volumeToVolumeSize) {
        this.volumeToVolumeSize = volumeToVolumeSize;
    }

    public ConversionProperties withVolumeToVolumeSize(Map<String, Long> volumeToVolumeSize) {
        this.setVolumeToVolumeSize(volumeToVolumeSize);
        return this;
    }

    public ConversionProperties addVolumeToVolumeSizeEntry(String key, Long value) {
        if (null == this.volumeToVolumeSize) {
            this.volumeToVolumeSize = new HashMap<String, Long>();
        }
        if (this.volumeToVolumeSize.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.volumeToVolumeSize.put(key, value);
        return this;
    }

    public ConversionProperties clearVolumeToVolumeSizeEntries() {
        this.volumeToVolumeSize = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataTimestamp() != null) {
            sb.append("DataTimestamp: ").append(this.getDataTimestamp()).append(",");
        }
        if (this.getForceUefi() != null) {
            sb.append("ForceUefi: ").append(this.getForceUefi()).append(",");
        }
        if (this.getRootVolumeName() != null) {
            sb.append("RootVolumeName: ").append(this.getRootVolumeName()).append(",");
        }
        if (this.getVolumeToConversionMap() != null) {
            sb.append("VolumeToConversionMap: ").append(this.getVolumeToConversionMap()).append(",");
        }
        if (this.getVolumeToVolumeSize() != null) {
            sb.append("VolumeToVolumeSize: ").append(this.getVolumeToVolumeSize());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversionProperties)) {
            return false;
        }
        ConversionProperties other = (ConversionProperties)obj;
        if (other.getDataTimestamp() == null ^ this.getDataTimestamp() == null) {
            return false;
        }
        if (other.getDataTimestamp() != null && !other.getDataTimestamp().equals(this.getDataTimestamp())) {
            return false;
        }
        if (other.getForceUefi() == null ^ this.getForceUefi() == null) {
            return false;
        }
        if (other.getForceUefi() != null && !other.getForceUefi().equals(this.getForceUefi())) {
            return false;
        }
        if (other.getRootVolumeName() == null ^ this.getRootVolumeName() == null) {
            return false;
        }
        if (other.getRootVolumeName() != null && !other.getRootVolumeName().equals(this.getRootVolumeName())) {
            return false;
        }
        if (other.getVolumeToConversionMap() == null ^ this.getVolumeToConversionMap() == null) {
            return false;
        }
        if (other.getVolumeToConversionMap() != null && !other.getVolumeToConversionMap().equals(this.getVolumeToConversionMap())) {
            return false;
        }
        if (other.getVolumeToVolumeSize() == null ^ this.getVolumeToVolumeSize() == null) {
            return false;
        }
        return other.getVolumeToVolumeSize() == null || other.getVolumeToVolumeSize().equals(this.getVolumeToVolumeSize());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataTimestamp() == null ? 0 : this.getDataTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getForceUefi() == null ? 0 : this.getForceUefi().hashCode());
        hashCode = 31 * hashCode + (this.getRootVolumeName() == null ? 0 : this.getRootVolumeName().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeToConversionMap() == null ? 0 : this.getVolumeToConversionMap().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeToVolumeSize() == null ? 0 : this.getVolumeToVolumeSize().hashCode());
        return hashCode;
    }

    public ConversionProperties clone() {
        try {
            return (ConversionProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConversionPropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

