/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.databasemigrationservice.model.ReplicationPendingModifiedValues;
import com.amazonaws.services.databasemigrationservice.model.ReplicationSubnetGroup;
import com.amazonaws.services.databasemigrationservice.model.VpcSecurityGroupMembership;
import com.amazonaws.services.databasemigrationservice.model.transform.ReplicationInstanceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ReplicationInstance
implements Serializable,
Cloneable,
StructuredPojo {
    private String replicationInstanceIdentifier;
    private String replicationInstanceClass;
    private String replicationInstanceStatus;
    private Integer allocatedStorage;
    private Date instanceCreateTime;
    private List<VpcSecurityGroupMembership> vpcSecurityGroups;
    private String availabilityZone;
    private ReplicationSubnetGroup replicationSubnetGroup;
    private String preferredMaintenanceWindow;
    private ReplicationPendingModifiedValues pendingModifiedValues;
    private Boolean multiAZ;
    private String engineVersion;
    private Boolean autoMinorVersionUpgrade;
    private String kmsKeyId;
    private String replicationInstanceArn;
    @Deprecated
    private String replicationInstancePublicIpAddress;
    @Deprecated
    private String replicationInstancePrivateIpAddress;
    private List<String> replicationInstancePublicIpAddresses;
    private List<String> replicationInstancePrivateIpAddresses;
    private List<String> replicationInstanceIpv6Addresses;
    private Boolean publiclyAccessible;
    private String secondaryAvailabilityZone;
    private Date freeUntil;
    private String dnsNameServers;
    private String networkType;

    public void setReplicationInstanceIdentifier(String replicationInstanceIdentifier) {
        this.replicationInstanceIdentifier = replicationInstanceIdentifier;
    }

    public String getReplicationInstanceIdentifier() {
        return this.replicationInstanceIdentifier;
    }

    public ReplicationInstance withReplicationInstanceIdentifier(String replicationInstanceIdentifier) {
        this.setReplicationInstanceIdentifier(replicationInstanceIdentifier);
        return this;
    }

    public void setReplicationInstanceClass(String replicationInstanceClass) {
        this.replicationInstanceClass = replicationInstanceClass;
    }

    public String getReplicationInstanceClass() {
        return this.replicationInstanceClass;
    }

    public ReplicationInstance withReplicationInstanceClass(String replicationInstanceClass) {
        this.setReplicationInstanceClass(replicationInstanceClass);
        return this;
    }

    public void setReplicationInstanceStatus(String replicationInstanceStatus) {
        this.replicationInstanceStatus = replicationInstanceStatus;
    }

    public String getReplicationInstanceStatus() {
        return this.replicationInstanceStatus;
    }

    public ReplicationInstance withReplicationInstanceStatus(String replicationInstanceStatus) {
        this.setReplicationInstanceStatus(replicationInstanceStatus);
        return this;
    }

    public void setAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
    }

    public Integer getAllocatedStorage() {
        return this.allocatedStorage;
    }

    public ReplicationInstance withAllocatedStorage(Integer allocatedStorage) {
        this.setAllocatedStorage(allocatedStorage);
        return this;
    }

    public void setInstanceCreateTime(Date instanceCreateTime) {
        this.instanceCreateTime = instanceCreateTime;
    }

    public Date getInstanceCreateTime() {
        return this.instanceCreateTime;
    }

    public ReplicationInstance withInstanceCreateTime(Date instanceCreateTime) {
        this.setInstanceCreateTime(instanceCreateTime);
        return this;
    }

    public List<VpcSecurityGroupMembership> getVpcSecurityGroups() {
        return this.vpcSecurityGroups;
    }

    public void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
        if (vpcSecurityGroups == null) {
            this.vpcSecurityGroups = null;
            return;
        }
        this.vpcSecurityGroups = new ArrayList<VpcSecurityGroupMembership>(vpcSecurityGroups);
    }

    public ReplicationInstance withVpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
        if (this.vpcSecurityGroups == null) {
            this.setVpcSecurityGroups(new ArrayList<VpcSecurityGroupMembership>(vpcSecurityGroups.length));
        }
        for (VpcSecurityGroupMembership ele : vpcSecurityGroups) {
            this.vpcSecurityGroups.add(ele);
        }
        return this;
    }

    public ReplicationInstance withVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
        this.setVpcSecurityGroups(vpcSecurityGroups);
        return this;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public ReplicationInstance withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public void setReplicationSubnetGroup(ReplicationSubnetGroup replicationSubnetGroup) {
        this.replicationSubnetGroup = replicationSubnetGroup;
    }

    public ReplicationSubnetGroup getReplicationSubnetGroup() {
        return this.replicationSubnetGroup;
    }

    public ReplicationInstance withReplicationSubnetGroup(ReplicationSubnetGroup replicationSubnetGroup) {
        this.setReplicationSubnetGroup(replicationSubnetGroup);
        return this;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public ReplicationInstance withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.setPreferredMaintenanceWindow(preferredMaintenanceWindow);
        return this;
    }

    public void setPendingModifiedValues(ReplicationPendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
    }

    public ReplicationPendingModifiedValues getPendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public ReplicationInstance withPendingModifiedValues(ReplicationPendingModifiedValues pendingModifiedValues) {
        this.setPendingModifiedValues(pendingModifiedValues);
        return this;
    }

    public void setMultiAZ(Boolean multiAZ) {
        this.multiAZ = multiAZ;
    }

    public Boolean getMultiAZ() {
        return this.multiAZ;
    }

    public ReplicationInstance withMultiAZ(Boolean multiAZ) {
        this.setMultiAZ(multiAZ);
        return this;
    }

    public Boolean isMultiAZ() {
        return this.multiAZ;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public ReplicationInstance withEngineVersion(String engineVersion) {
        this.setEngineVersion(engineVersion);
        return this;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public ReplicationInstance withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.setAutoMinorVersionUpgrade(autoMinorVersionUpgrade);
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public ReplicationInstance withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setReplicationInstanceArn(String replicationInstanceArn) {
        this.replicationInstanceArn = replicationInstanceArn;
    }

    public String getReplicationInstanceArn() {
        return this.replicationInstanceArn;
    }

    public ReplicationInstance withReplicationInstanceArn(String replicationInstanceArn) {
        this.setReplicationInstanceArn(replicationInstanceArn);
        return this;
    }

    @Deprecated
    public void setReplicationInstancePublicIpAddress(String replicationInstancePublicIpAddress) {
        this.replicationInstancePublicIpAddress = replicationInstancePublicIpAddress;
    }

    @Deprecated
    public String getReplicationInstancePublicIpAddress() {
        return this.replicationInstancePublicIpAddress;
    }

    @Deprecated
    public ReplicationInstance withReplicationInstancePublicIpAddress(String replicationInstancePublicIpAddress) {
        this.setReplicationInstancePublicIpAddress(replicationInstancePublicIpAddress);
        return this;
    }

    @Deprecated
    public void setReplicationInstancePrivateIpAddress(String replicationInstancePrivateIpAddress) {
        this.replicationInstancePrivateIpAddress = replicationInstancePrivateIpAddress;
    }

    @Deprecated
    public String getReplicationInstancePrivateIpAddress() {
        return this.replicationInstancePrivateIpAddress;
    }

    @Deprecated
    public ReplicationInstance withReplicationInstancePrivateIpAddress(String replicationInstancePrivateIpAddress) {
        this.setReplicationInstancePrivateIpAddress(replicationInstancePrivateIpAddress);
        return this;
    }

    public List<String> getReplicationInstancePublicIpAddresses() {
        return this.replicationInstancePublicIpAddresses;
    }

    public void setReplicationInstancePublicIpAddresses(Collection<String> replicationInstancePublicIpAddresses) {
        if (replicationInstancePublicIpAddresses == null) {
            this.replicationInstancePublicIpAddresses = null;
            return;
        }
        this.replicationInstancePublicIpAddresses = new ArrayList<String>(replicationInstancePublicIpAddresses);
    }

    public ReplicationInstance withReplicationInstancePublicIpAddresses(String ... replicationInstancePublicIpAddresses) {
        if (this.replicationInstancePublicIpAddresses == null) {
            this.setReplicationInstancePublicIpAddresses(new ArrayList<String>(replicationInstancePublicIpAddresses.length));
        }
        for (String ele : replicationInstancePublicIpAddresses) {
            this.replicationInstancePublicIpAddresses.add(ele);
        }
        return this;
    }

    public ReplicationInstance withReplicationInstancePublicIpAddresses(Collection<String> replicationInstancePublicIpAddresses) {
        this.setReplicationInstancePublicIpAddresses(replicationInstancePublicIpAddresses);
        return this;
    }

    public List<String> getReplicationInstancePrivateIpAddresses() {
        return this.replicationInstancePrivateIpAddresses;
    }

    public void setReplicationInstancePrivateIpAddresses(Collection<String> replicationInstancePrivateIpAddresses) {
        if (replicationInstancePrivateIpAddresses == null) {
            this.replicationInstancePrivateIpAddresses = null;
            return;
        }
        this.replicationInstancePrivateIpAddresses = new ArrayList<String>(replicationInstancePrivateIpAddresses);
    }

    public ReplicationInstance withReplicationInstancePrivateIpAddresses(String ... replicationInstancePrivateIpAddresses) {
        if (this.replicationInstancePrivateIpAddresses == null) {
            this.setReplicationInstancePrivateIpAddresses(new ArrayList<String>(replicationInstancePrivateIpAddresses.length));
        }
        for (String ele : replicationInstancePrivateIpAddresses) {
            this.replicationInstancePrivateIpAddresses.add(ele);
        }
        return this;
    }

    public ReplicationInstance withReplicationInstancePrivateIpAddresses(Collection<String> replicationInstancePrivateIpAddresses) {
        this.setReplicationInstancePrivateIpAddresses(replicationInstancePrivateIpAddresses);
        return this;
    }

    public List<String> getReplicationInstanceIpv6Addresses() {
        return this.replicationInstanceIpv6Addresses;
    }

    public void setReplicationInstanceIpv6Addresses(Collection<String> replicationInstanceIpv6Addresses) {
        if (replicationInstanceIpv6Addresses == null) {
            this.replicationInstanceIpv6Addresses = null;
            return;
        }
        this.replicationInstanceIpv6Addresses = new ArrayList<String>(replicationInstanceIpv6Addresses);
    }

    public ReplicationInstance withReplicationInstanceIpv6Addresses(String ... replicationInstanceIpv6Addresses) {
        if (this.replicationInstanceIpv6Addresses == null) {
            this.setReplicationInstanceIpv6Addresses(new ArrayList<String>(replicationInstanceIpv6Addresses.length));
        }
        for (String ele : replicationInstanceIpv6Addresses) {
            this.replicationInstanceIpv6Addresses.add(ele);
        }
        return this;
    }

    public ReplicationInstance withReplicationInstanceIpv6Addresses(Collection<String> replicationInstanceIpv6Addresses) {
        this.setReplicationInstanceIpv6Addresses(replicationInstanceIpv6Addresses);
        return this;
    }

    public void setPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
    }

    public Boolean getPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public ReplicationInstance withPubliclyAccessible(Boolean publiclyAccessible) {
        this.setPubliclyAccessible(publiclyAccessible);
        return this;
    }

    public Boolean isPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public void setSecondaryAvailabilityZone(String secondaryAvailabilityZone) {
        this.secondaryAvailabilityZone = secondaryAvailabilityZone;
    }

    public String getSecondaryAvailabilityZone() {
        return this.secondaryAvailabilityZone;
    }

    public ReplicationInstance withSecondaryAvailabilityZone(String secondaryAvailabilityZone) {
        this.setSecondaryAvailabilityZone(secondaryAvailabilityZone);
        return this;
    }

    public void setFreeUntil(Date freeUntil) {
        this.freeUntil = freeUntil;
    }

    public Date getFreeUntil() {
        return this.freeUntil;
    }

    public ReplicationInstance withFreeUntil(Date freeUntil) {
        this.setFreeUntil(freeUntil);
        return this;
    }

    public void setDnsNameServers(String dnsNameServers) {
        this.dnsNameServers = dnsNameServers;
    }

    public String getDnsNameServers() {
        return this.dnsNameServers;
    }

    public ReplicationInstance withDnsNameServers(String dnsNameServers) {
        this.setDnsNameServers(dnsNameServers);
        return this;
    }

    public void setNetworkType(String networkType) {
        this.networkType = networkType;
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public ReplicationInstance withNetworkType(String networkType) {
        this.setNetworkType(networkType);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReplicationInstanceIdentifier() != null) {
            sb.append("ReplicationInstanceIdentifier: ").append(this.getReplicationInstanceIdentifier()).append(",");
        }
        if (this.getReplicationInstanceClass() != null) {
            sb.append("ReplicationInstanceClass: ").append(this.getReplicationInstanceClass()).append(",");
        }
        if (this.getReplicationInstanceStatus() != null) {
            sb.append("ReplicationInstanceStatus: ").append(this.getReplicationInstanceStatus()).append(",");
        }
        if (this.getAllocatedStorage() != null) {
            sb.append("AllocatedStorage: ").append(this.getAllocatedStorage()).append(",");
        }
        if (this.getInstanceCreateTime() != null) {
            sb.append("InstanceCreateTime: ").append(this.getInstanceCreateTime()).append(",");
        }
        if (this.getVpcSecurityGroups() != null) {
            sb.append("VpcSecurityGroups: ").append(this.getVpcSecurityGroups()).append(",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.getAvailabilityZone()).append(",");
        }
        if (this.getReplicationSubnetGroup() != null) {
            sb.append("ReplicationSubnetGroup: ").append(this.getReplicationSubnetGroup()).append(",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.getPreferredMaintenanceWindow()).append(",");
        }
        if (this.getPendingModifiedValues() != null) {
            sb.append("PendingModifiedValues: ").append(this.getPendingModifiedValues()).append(",");
        }
        if (this.getMultiAZ() != null) {
            sb.append("MultiAZ: ").append(this.getMultiAZ()).append(",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: ").append(this.getEngineVersion()).append(",");
        }
        if (this.getAutoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: ").append(this.getAutoMinorVersionUpgrade()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getReplicationInstanceArn() != null) {
            sb.append("ReplicationInstanceArn: ").append(this.getReplicationInstanceArn()).append(",");
        }
        if (this.getReplicationInstancePublicIpAddress() != null) {
            sb.append("ReplicationInstancePublicIpAddress: ").append(this.getReplicationInstancePublicIpAddress()).append(",");
        }
        if (this.getReplicationInstancePrivateIpAddress() != null) {
            sb.append("ReplicationInstancePrivateIpAddress: ").append(this.getReplicationInstancePrivateIpAddress()).append(",");
        }
        if (this.getReplicationInstancePublicIpAddresses() != null) {
            sb.append("ReplicationInstancePublicIpAddresses: ").append(this.getReplicationInstancePublicIpAddresses()).append(",");
        }
        if (this.getReplicationInstancePrivateIpAddresses() != null) {
            sb.append("ReplicationInstancePrivateIpAddresses: ").append(this.getReplicationInstancePrivateIpAddresses()).append(",");
        }
        if (this.getReplicationInstanceIpv6Addresses() != null) {
            sb.append("ReplicationInstanceIpv6Addresses: ").append(this.getReplicationInstanceIpv6Addresses()).append(",");
        }
        if (this.getPubliclyAccessible() != null) {
            sb.append("PubliclyAccessible: ").append(this.getPubliclyAccessible()).append(",");
        }
        if (this.getSecondaryAvailabilityZone() != null) {
            sb.append("SecondaryAvailabilityZone: ").append(this.getSecondaryAvailabilityZone()).append(",");
        }
        if (this.getFreeUntil() != null) {
            sb.append("FreeUntil: ").append(this.getFreeUntil()).append(",");
        }
        if (this.getDnsNameServers() != null) {
            sb.append("DnsNameServers: ").append(this.getDnsNameServers()).append(",");
        }
        if (this.getNetworkType() != null) {
            sb.append("NetworkType: ").append(this.getNetworkType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationInstance)) {
            return false;
        }
        ReplicationInstance other = (ReplicationInstance)obj;
        if (other.getReplicationInstanceIdentifier() == null ^ this.getReplicationInstanceIdentifier() == null) {
            return false;
        }
        if (other.getReplicationInstanceIdentifier() != null && !other.getReplicationInstanceIdentifier().equals(this.getReplicationInstanceIdentifier())) {
            return false;
        }
        if (other.getReplicationInstanceClass() == null ^ this.getReplicationInstanceClass() == null) {
            return false;
        }
        if (other.getReplicationInstanceClass() != null && !other.getReplicationInstanceClass().equals(this.getReplicationInstanceClass())) {
            return false;
        }
        if (other.getReplicationInstanceStatus() == null ^ this.getReplicationInstanceStatus() == null) {
            return false;
        }
        if (other.getReplicationInstanceStatus() != null && !other.getReplicationInstanceStatus().equals(this.getReplicationInstanceStatus())) {
            return false;
        }
        if (other.getAllocatedStorage() == null ^ this.getAllocatedStorage() == null) {
            return false;
        }
        if (other.getAllocatedStorage() != null && !other.getAllocatedStorage().equals(this.getAllocatedStorage())) {
            return false;
        }
        if (other.getInstanceCreateTime() == null ^ this.getInstanceCreateTime() == null) {
            return false;
        }
        if (other.getInstanceCreateTime() != null && !other.getInstanceCreateTime().equals(this.getInstanceCreateTime())) {
            return false;
        }
        if (other.getVpcSecurityGroups() == null ^ this.getVpcSecurityGroups() == null) {
            return false;
        }
        if (other.getVpcSecurityGroups() != null && !other.getVpcSecurityGroups().equals(this.getVpcSecurityGroups())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getReplicationSubnetGroup() == null ^ this.getReplicationSubnetGroup() == null) {
            return false;
        }
        if (other.getReplicationSubnetGroup() != null && !other.getReplicationSubnetGroup().equals(this.getReplicationSubnetGroup())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getPendingModifiedValues() == null ^ this.getPendingModifiedValues() == null) {
            return false;
        }
        if (other.getPendingModifiedValues() != null && !other.getPendingModifiedValues().equals(this.getPendingModifiedValues())) {
            return false;
        }
        if (other.getMultiAZ() == null ^ this.getMultiAZ() == null) {
            return false;
        }
        if (other.getMultiAZ() != null && !other.getMultiAZ().equals(this.getMultiAZ())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getAutoMinorVersionUpgrade() == null ^ this.getAutoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.getAutoMinorVersionUpgrade() != null && !other.getAutoMinorVersionUpgrade().equals(this.getAutoMinorVersionUpgrade())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getReplicationInstanceArn() == null ^ this.getReplicationInstanceArn() == null) {
            return false;
        }
        if (other.getReplicationInstanceArn() != null && !other.getReplicationInstanceArn().equals(this.getReplicationInstanceArn())) {
            return false;
        }
        if (other.getReplicationInstancePublicIpAddress() == null ^ this.getReplicationInstancePublicIpAddress() == null) {
            return false;
        }
        if (other.getReplicationInstancePublicIpAddress() != null && !other.getReplicationInstancePublicIpAddress().equals(this.getReplicationInstancePublicIpAddress())) {
            return false;
        }
        if (other.getReplicationInstancePrivateIpAddress() == null ^ this.getReplicationInstancePrivateIpAddress() == null) {
            return false;
        }
        if (other.getReplicationInstancePrivateIpAddress() != null && !other.getReplicationInstancePrivateIpAddress().equals(this.getReplicationInstancePrivateIpAddress())) {
            return false;
        }
        if (other.getReplicationInstancePublicIpAddresses() == null ^ this.getReplicationInstancePublicIpAddresses() == null) {
            return false;
        }
        if (other.getReplicationInstancePublicIpAddresses() != null && !other.getReplicationInstancePublicIpAddresses().equals(this.getReplicationInstancePublicIpAddresses())) {
            return false;
        }
        if (other.getReplicationInstancePrivateIpAddresses() == null ^ this.getReplicationInstancePrivateIpAddresses() == null) {
            return false;
        }
        if (other.getReplicationInstancePrivateIpAddresses() != null && !other.getReplicationInstancePrivateIpAddresses().equals(this.getReplicationInstancePrivateIpAddresses())) {
            return false;
        }
        if (other.getReplicationInstanceIpv6Addresses() == null ^ this.getReplicationInstanceIpv6Addresses() == null) {
            return false;
        }
        if (other.getReplicationInstanceIpv6Addresses() != null && !other.getReplicationInstanceIpv6Addresses().equals(this.getReplicationInstanceIpv6Addresses())) {
            return false;
        }
        if (other.getPubliclyAccessible() == null ^ this.getPubliclyAccessible() == null) {
            return false;
        }
        if (other.getPubliclyAccessible() != null && !other.getPubliclyAccessible().equals(this.getPubliclyAccessible())) {
            return false;
        }
        if (other.getSecondaryAvailabilityZone() == null ^ this.getSecondaryAvailabilityZone() == null) {
            return false;
        }
        if (other.getSecondaryAvailabilityZone() != null && !other.getSecondaryAvailabilityZone().equals(this.getSecondaryAvailabilityZone())) {
            return false;
        }
        if (other.getFreeUntil() == null ^ this.getFreeUntil() == null) {
            return false;
        }
        if (other.getFreeUntil() != null && !other.getFreeUntil().equals(this.getFreeUntil())) {
            return false;
        }
        if (other.getDnsNameServers() == null ^ this.getDnsNameServers() == null) {
            return false;
        }
        if (other.getDnsNameServers() != null && !other.getDnsNameServers().equals(this.getDnsNameServers())) {
            return false;
        }
        if (other.getNetworkType() == null ^ this.getNetworkType() == null) {
            return false;
        }
        return other.getNetworkType() == null || other.getNetworkType().equals(this.getNetworkType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReplicationInstanceIdentifier() == null ? 0 : this.getReplicationInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationInstanceClass() == null ? 0 : this.getReplicationInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationInstanceStatus() == null ? 0 : this.getReplicationInstanceStatus().hashCode());
        hashCode = 31 * hashCode + (this.getAllocatedStorage() == null ? 0 : this.getAllocatedStorage().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceCreateTime() == null ? 0 : this.getInstanceCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getVpcSecurityGroups() == null ? 0 : this.getVpcSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationSubnetGroup() == null ? 0 : this.getReplicationSubnetGroup().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getPendingModifiedValues() == null ? 0 : this.getPendingModifiedValues().hashCode());
        hashCode = 31 * hashCode + (this.getMultiAZ() == null ? 0 : this.getMultiAZ().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getAutoMinorVersionUpgrade() == null ? 0 : this.getAutoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationInstanceArn() == null ? 0 : this.getReplicationInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationInstancePublicIpAddress() == null ? 0 : this.getReplicationInstancePublicIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationInstancePrivateIpAddress() == null ? 0 : this.getReplicationInstancePrivateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationInstancePublicIpAddresses() == null ? 0 : this.getReplicationInstancePublicIpAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationInstancePrivateIpAddresses() == null ? 0 : this.getReplicationInstancePrivateIpAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationInstanceIpv6Addresses() == null ? 0 : this.getReplicationInstanceIpv6Addresses().hashCode());
        hashCode = 31 * hashCode + (this.getPubliclyAccessible() == null ? 0 : this.getPubliclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryAvailabilityZone() == null ? 0 : this.getSecondaryAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getFreeUntil() == null ? 0 : this.getFreeUntil().hashCode());
        hashCode = 31 * hashCode + (this.getDnsNameServers() == null ? 0 : this.getDnsNameServers().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkType() == null ? 0 : this.getNetworkType().hashCode());
        return hashCode;
    }

    public ReplicationInstance clone() {
        try {
            return (ReplicationInstance)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReplicationInstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

