/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.databasemigrationservice.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * ReloadReplicationTablesRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class ReloadReplicationTablesRequestMarshaller {

    private static final MarshallingInfo<String> REPLICATIONCONFIGARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationConfigArn").build();
    private static final MarshallingInfo<List> TABLESTORELOAD_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TablesToReload").build();
    private static final MarshallingInfo<String> RELOADOPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReloadOption").build();

    private static final ReloadReplicationTablesRequestMarshaller instance = new ReloadReplicationTablesRequestMarshaller();

    public static ReloadReplicationTablesRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ReloadReplicationTablesRequest reloadReplicationTablesRequest, ProtocolMarshaller protocolMarshaller) {

        if (reloadReplicationTablesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(reloadReplicationTablesRequest.getReplicationConfigArn(), REPLICATIONCONFIGARN_BINDING);
            protocolMarshaller.marshall(reloadReplicationTablesRequest.getTablesToReload(), TABLESTORELOAD_BINDING);
            protocolMarshaller.marshall(reloadReplicationTablesRequest.getReloadOption(), RELOADOPTION_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
