/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.databasemigrationservice.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Provides information that defines an OpenSearch endpoint.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ElasticsearchSettings" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ElasticsearchSettings implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the
     * <code>iam:PassRole</code> action.
     * </p>
     */
    private String serviceAccessRoleArn;
    /**
     * <p>
     * The endpoint for the OpenSearch cluster. DMS uses HTTPS if a transport protocol (http/https) is not specified.
     * </p>
     */
    private String endpointUri;
    /**
     * <p>
     * The maximum percentage of records that can fail to be written before a full load operation stops.
     * </p>
     * <p>
     * To avoid early failure, this counter is only effective after 1000 records are transferred. OpenSearch also has
     * the concept of error monitoring during the last 10 minutes of an Observation Window. If transfer of all records
     * fail in the last 10 minutes, the full load operation stops.
     * </p>
     */
    private Integer fullLoadErrorPercentage;
    /**
     * <p>
     * The maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster.
     * </p>
     */
    private Integer errorRetryDuration;
    /**
     * <p>
     * Set this option to <code>true</code> for DMS to migrate documentation using the documentation type
     * <code>_doc</code>. OpenSearch and an Elasticsearch cluster only support the _doc documentation type in versions
     * 7. x and later. The default value is <code>false</code>.
     * </p>
     */
    private Boolean useNewMappingType;

    /**
     * <p>
     * The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the
     * <code>iam:PassRole</code> action.
     * </p>
     * 
     * @param serviceAccessRoleArn
     *        The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the
     *        <code>iam:PassRole</code> action.
     */

    public void setServiceAccessRoleArn(String serviceAccessRoleArn) {
        this.serviceAccessRoleArn = serviceAccessRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the
     * <code>iam:PassRole</code> action.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the
     *         <code>iam:PassRole</code> action.
     */

    public String getServiceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the
     * <code>iam:PassRole</code> action.
     * </p>
     * 
     * @param serviceAccessRoleArn
     *        The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the
     *        <code>iam:PassRole</code> action.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ElasticsearchSettings withServiceAccessRoleArn(String serviceAccessRoleArn) {
        setServiceAccessRoleArn(serviceAccessRoleArn);
        return this;
    }

    /**
     * <p>
     * The endpoint for the OpenSearch cluster. DMS uses HTTPS if a transport protocol (http/https) is not specified.
     * </p>
     * 
     * @param endpointUri
     *        The endpoint for the OpenSearch cluster. DMS uses HTTPS if a transport protocol (http/https) is not
     *        specified.
     */

    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    /**
     * <p>
     * The endpoint for the OpenSearch cluster. DMS uses HTTPS if a transport protocol (http/https) is not specified.
     * </p>
     * 
     * @return The endpoint for the OpenSearch cluster. DMS uses HTTPS if a transport protocol (http/https) is not
     *         specified.
     */

    public String getEndpointUri() {
        return this.endpointUri;
    }

    /**
     * <p>
     * The endpoint for the OpenSearch cluster. DMS uses HTTPS if a transport protocol (http/https) is not specified.
     * </p>
     * 
     * @param endpointUri
     *        The endpoint for the OpenSearch cluster. DMS uses HTTPS if a transport protocol (http/https) is not
     *        specified.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ElasticsearchSettings withEndpointUri(String endpointUri) {
        setEndpointUri(endpointUri);
        return this;
    }

    /**
     * <p>
     * The maximum percentage of records that can fail to be written before a full load operation stops.
     * </p>
     * <p>
     * To avoid early failure, this counter is only effective after 1000 records are transferred. OpenSearch also has
     * the concept of error monitoring during the last 10 minutes of an Observation Window. If transfer of all records
     * fail in the last 10 minutes, the full load operation stops.
     * </p>
     * 
     * @param fullLoadErrorPercentage
     *        The maximum percentage of records that can fail to be written before a full load operation stops.</p>
     *        <p>
     *        To avoid early failure, this counter is only effective after 1000 records are transferred. OpenSearch also
     *        has the concept of error monitoring during the last 10 minutes of an Observation Window. If transfer of
     *        all records fail in the last 10 minutes, the full load operation stops.
     */

    public void setFullLoadErrorPercentage(Integer fullLoadErrorPercentage) {
        this.fullLoadErrorPercentage = fullLoadErrorPercentage;
    }

    /**
     * <p>
     * The maximum percentage of records that can fail to be written before a full load operation stops.
     * </p>
     * <p>
     * To avoid early failure, this counter is only effective after 1000 records are transferred. OpenSearch also has
     * the concept of error monitoring during the last 10 minutes of an Observation Window. If transfer of all records
     * fail in the last 10 minutes, the full load operation stops.
     * </p>
     * 
     * @return The maximum percentage of records that can fail to be written before a full load operation stops.</p>
     *         <p>
     *         To avoid early failure, this counter is only effective after 1000 records are transferred. OpenSearch
     *         also has the concept of error monitoring during the last 10 minutes of an Observation Window. If transfer
     *         of all records fail in the last 10 minutes, the full load operation stops.
     */

    public Integer getFullLoadErrorPercentage() {
        return this.fullLoadErrorPercentage;
    }

    /**
     * <p>
     * The maximum percentage of records that can fail to be written before a full load operation stops.
     * </p>
     * <p>
     * To avoid early failure, this counter is only effective after 1000 records are transferred. OpenSearch also has
     * the concept of error monitoring during the last 10 minutes of an Observation Window. If transfer of all records
     * fail in the last 10 minutes, the full load operation stops.
     * </p>
     * 
     * @param fullLoadErrorPercentage
     *        The maximum percentage of records that can fail to be written before a full load operation stops.</p>
     *        <p>
     *        To avoid early failure, this counter is only effective after 1000 records are transferred. OpenSearch also
     *        has the concept of error monitoring during the last 10 minutes of an Observation Window. If transfer of
     *        all records fail in the last 10 minutes, the full load operation stops.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ElasticsearchSettings withFullLoadErrorPercentage(Integer fullLoadErrorPercentage) {
        setFullLoadErrorPercentage(fullLoadErrorPercentage);
        return this;
    }

    /**
     * <p>
     * The maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster.
     * </p>
     * 
     * @param errorRetryDuration
     *        The maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster.
     */

    public void setErrorRetryDuration(Integer errorRetryDuration) {
        this.errorRetryDuration = errorRetryDuration;
    }

    /**
     * <p>
     * The maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster.
     * </p>
     * 
     * @return The maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster.
     */

    public Integer getErrorRetryDuration() {
        return this.errorRetryDuration;
    }

    /**
     * <p>
     * The maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster.
     * </p>
     * 
     * @param errorRetryDuration
     *        The maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ElasticsearchSettings withErrorRetryDuration(Integer errorRetryDuration) {
        setErrorRetryDuration(errorRetryDuration);
        return this;
    }

    /**
     * <p>
     * Set this option to <code>true</code> for DMS to migrate documentation using the documentation type
     * <code>_doc</code>. OpenSearch and an Elasticsearch cluster only support the _doc documentation type in versions
     * 7. x and later. The default value is <code>false</code>.
     * </p>
     * 
     * @param useNewMappingType
     *        Set this option to <code>true</code> for DMS to migrate documentation using the documentation type
     *        <code>_doc</code>. OpenSearch and an Elasticsearch cluster only support the _doc documentation type in
     *        versions 7. x and later. The default value is <code>false</code>.
     */

    public void setUseNewMappingType(Boolean useNewMappingType) {
        this.useNewMappingType = useNewMappingType;
    }

    /**
     * <p>
     * Set this option to <code>true</code> for DMS to migrate documentation using the documentation type
     * <code>_doc</code>. OpenSearch and an Elasticsearch cluster only support the _doc documentation type in versions
     * 7. x and later. The default value is <code>false</code>.
     * </p>
     * 
     * @return Set this option to <code>true</code> for DMS to migrate documentation using the documentation type
     *         <code>_doc</code>. OpenSearch and an Elasticsearch cluster only support the _doc documentation type in
     *         versions 7. x and later. The default value is <code>false</code>.
     */

    public Boolean getUseNewMappingType() {
        return this.useNewMappingType;
    }

    /**
     * <p>
     * Set this option to <code>true</code> for DMS to migrate documentation using the documentation type
     * <code>_doc</code>. OpenSearch and an Elasticsearch cluster only support the _doc documentation type in versions
     * 7. x and later. The default value is <code>false</code>.
     * </p>
     * 
     * @param useNewMappingType
     *        Set this option to <code>true</code> for DMS to migrate documentation using the documentation type
     *        <code>_doc</code>. OpenSearch and an Elasticsearch cluster only support the _doc documentation type in
     *        versions 7. x and later. The default value is <code>false</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ElasticsearchSettings withUseNewMappingType(Boolean useNewMappingType) {
        setUseNewMappingType(useNewMappingType);
        return this;
    }

    /**
     * <p>
     * Set this option to <code>true</code> for DMS to migrate documentation using the documentation type
     * <code>_doc</code>. OpenSearch and an Elasticsearch cluster only support the _doc documentation type in versions
     * 7. x and later. The default value is <code>false</code>.
     * </p>
     * 
     * @return Set this option to <code>true</code> for DMS to migrate documentation using the documentation type
     *         <code>_doc</code>. OpenSearch and an Elasticsearch cluster only support the _doc documentation type in
     *         versions 7. x and later. The default value is <code>false</code>.
     */

    public Boolean isUseNewMappingType() {
        return this.useNewMappingType;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getServiceAccessRoleArn() != null)
            sb.append("ServiceAccessRoleArn: ").append(getServiceAccessRoleArn()).append(",");
        if (getEndpointUri() != null)
            sb.append("EndpointUri: ").append(getEndpointUri()).append(",");
        if (getFullLoadErrorPercentage() != null)
            sb.append("FullLoadErrorPercentage: ").append(getFullLoadErrorPercentage()).append(",");
        if (getErrorRetryDuration() != null)
            sb.append("ErrorRetryDuration: ").append(getErrorRetryDuration()).append(",");
        if (getUseNewMappingType() != null)
            sb.append("UseNewMappingType: ").append(getUseNewMappingType());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ElasticsearchSettings == false)
            return false;
        ElasticsearchSettings other = (ElasticsearchSettings) obj;
        if (other.getServiceAccessRoleArn() == null ^ this.getServiceAccessRoleArn() == null)
            return false;
        if (other.getServiceAccessRoleArn() != null && other.getServiceAccessRoleArn().equals(this.getServiceAccessRoleArn()) == false)
            return false;
        if (other.getEndpointUri() == null ^ this.getEndpointUri() == null)
            return false;
        if (other.getEndpointUri() != null && other.getEndpointUri().equals(this.getEndpointUri()) == false)
            return false;
        if (other.getFullLoadErrorPercentage() == null ^ this.getFullLoadErrorPercentage() == null)
            return false;
        if (other.getFullLoadErrorPercentage() != null && other.getFullLoadErrorPercentage().equals(this.getFullLoadErrorPercentage()) == false)
            return false;
        if (other.getErrorRetryDuration() == null ^ this.getErrorRetryDuration() == null)
            return false;
        if (other.getErrorRetryDuration() != null && other.getErrorRetryDuration().equals(this.getErrorRetryDuration()) == false)
            return false;
        if (other.getUseNewMappingType() == null ^ this.getUseNewMappingType() == null)
            return false;
        if (other.getUseNewMappingType() != null && other.getUseNewMappingType().equals(this.getUseNewMappingType()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getServiceAccessRoleArn() == null) ? 0 : getServiceAccessRoleArn().hashCode());
        hashCode = prime * hashCode + ((getEndpointUri() == null) ? 0 : getEndpointUri().hashCode());
        hashCode = prime * hashCode + ((getFullLoadErrorPercentage() == null) ? 0 : getFullLoadErrorPercentage().hashCode());
        hashCode = prime * hashCode + ((getErrorRetryDuration() == null) ? 0 : getErrorRetryDuration().hashCode());
        hashCode = prime * hashCode + ((getUseNewMappingType() == null) ? 0 : getUseNewMappingType().hashCode());
        return hashCode;
    }

    @Override
    public ElasticsearchSettings clone() {
        try {
            return (ElasticsearchSettings) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.databasemigrationservice.model.transform.ElasticsearchSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
