/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.databasemigrationservice.model.CreateReplicationTaskRequest;
import com.amazonaws.services.databasemigrationservice.model.Tag;
import com.amazonaws.services.databasemigrationservice.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class CreateReplicationTaskRequestMarshaller
implements Marshaller<Request<CreateReplicationTaskRequest>, CreateReplicationTaskRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateReplicationTaskRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateReplicationTaskRequest> marshall(CreateReplicationTaskRequest createReplicationTaskRequest) {
        if (createReplicationTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createReplicationTaskRequest, "AWSDatabaseMigrationService");
        request.addHeader("X-Amz-Target", "AmazonDMSv20160101.CreateReplicationTask");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Tag> tagsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createReplicationTaskRequest.getReplicationTaskIdentifier() != null) {
                jsonGenerator.writeFieldName("ReplicationTaskIdentifier").writeValue(createReplicationTaskRequest.getReplicationTaskIdentifier());
            }
            if (createReplicationTaskRequest.getSourceEndpointArn() != null) {
                jsonGenerator.writeFieldName("SourceEndpointArn").writeValue(createReplicationTaskRequest.getSourceEndpointArn());
            }
            if (createReplicationTaskRequest.getTargetEndpointArn() != null) {
                jsonGenerator.writeFieldName("TargetEndpointArn").writeValue(createReplicationTaskRequest.getTargetEndpointArn());
            }
            if (createReplicationTaskRequest.getReplicationInstanceArn() != null) {
                jsonGenerator.writeFieldName("ReplicationInstanceArn").writeValue(createReplicationTaskRequest.getReplicationInstanceArn());
            }
            if (createReplicationTaskRequest.getMigrationType() != null) {
                jsonGenerator.writeFieldName("MigrationType").writeValue(createReplicationTaskRequest.getMigrationType());
            }
            if (createReplicationTaskRequest.getTableMappings() != null) {
                jsonGenerator.writeFieldName("TableMappings").writeValue(createReplicationTaskRequest.getTableMappings());
            }
            if (createReplicationTaskRequest.getReplicationTaskSettings() != null) {
                jsonGenerator.writeFieldName("ReplicationTaskSettings").writeValue(createReplicationTaskRequest.getReplicationTaskSettings());
            }
            if (createReplicationTaskRequest.getCdcStartTime() != null) {
                jsonGenerator.writeFieldName("CdcStartTime").writeValue(createReplicationTaskRequest.getCdcStartTime());
            }
            if ((tagsList = createReplicationTaskRequest.getTags()) != null) {
                jsonGenerator.writeFieldName("Tags");
                jsonGenerator.writeStartArray();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

