/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dlm.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dlm.model.ExecutionHandlerServiceValues;
import com.amazonaws.services.dlm.model.StageValues;
import com.amazonaws.services.dlm.model.transform.ScriptMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Script
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> stages;
    private String executionHandlerService;
    private String executionHandler;
    private Boolean executeOperationOnScriptFailure;
    private Integer executionTimeout;
    private Integer maximumRetryCount;

    public List<String> getStages() {
        return this.stages;
    }

    public void setStages(Collection<String> stages) {
        if (stages == null) {
            this.stages = null;
            return;
        }
        this.stages = new ArrayList<String>(stages);
    }

    public Script withStages(String ... stages) {
        if (this.stages == null) {
            this.setStages(new ArrayList<String>(stages.length));
        }
        for (String ele : stages) {
            this.stages.add(ele);
        }
        return this;
    }

    public Script withStages(Collection<String> stages) {
        this.setStages(stages);
        return this;
    }

    public Script withStages(StageValues ... stages) {
        ArrayList<String> stagesCopy = new ArrayList<String>(stages.length);
        for (StageValues value : stages) {
            stagesCopy.add(value.toString());
        }
        if (this.getStages() == null) {
            this.setStages(stagesCopy);
        } else {
            this.getStages().addAll(stagesCopy);
        }
        return this;
    }

    public void setExecutionHandlerService(String executionHandlerService) {
        this.executionHandlerService = executionHandlerService;
    }

    public String getExecutionHandlerService() {
        return this.executionHandlerService;
    }

    public Script withExecutionHandlerService(String executionHandlerService) {
        this.setExecutionHandlerService(executionHandlerService);
        return this;
    }

    public Script withExecutionHandlerService(ExecutionHandlerServiceValues executionHandlerService) {
        this.executionHandlerService = executionHandlerService.toString();
        return this;
    }

    public void setExecutionHandler(String executionHandler) {
        this.executionHandler = executionHandler;
    }

    public String getExecutionHandler() {
        return this.executionHandler;
    }

    public Script withExecutionHandler(String executionHandler) {
        this.setExecutionHandler(executionHandler);
        return this;
    }

    public void setExecuteOperationOnScriptFailure(Boolean executeOperationOnScriptFailure) {
        this.executeOperationOnScriptFailure = executeOperationOnScriptFailure;
    }

    public Boolean getExecuteOperationOnScriptFailure() {
        return this.executeOperationOnScriptFailure;
    }

    public Script withExecuteOperationOnScriptFailure(Boolean executeOperationOnScriptFailure) {
        this.setExecuteOperationOnScriptFailure(executeOperationOnScriptFailure);
        return this;
    }

    public Boolean isExecuteOperationOnScriptFailure() {
        return this.executeOperationOnScriptFailure;
    }

    public void setExecutionTimeout(Integer executionTimeout) {
        this.executionTimeout = executionTimeout;
    }

    public Integer getExecutionTimeout() {
        return this.executionTimeout;
    }

    public Script withExecutionTimeout(Integer executionTimeout) {
        this.setExecutionTimeout(executionTimeout);
        return this;
    }

    public void setMaximumRetryCount(Integer maximumRetryCount) {
        this.maximumRetryCount = maximumRetryCount;
    }

    public Integer getMaximumRetryCount() {
        return this.maximumRetryCount;
    }

    public Script withMaximumRetryCount(Integer maximumRetryCount) {
        this.setMaximumRetryCount(maximumRetryCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStages() != null) {
            sb.append("Stages: ").append(this.getStages()).append(",");
        }
        if (this.getExecutionHandlerService() != null) {
            sb.append("ExecutionHandlerService: ").append(this.getExecutionHandlerService()).append(",");
        }
        if (this.getExecutionHandler() != null) {
            sb.append("ExecutionHandler: ").append(this.getExecutionHandler()).append(",");
        }
        if (this.getExecuteOperationOnScriptFailure() != null) {
            sb.append("ExecuteOperationOnScriptFailure: ").append(this.getExecuteOperationOnScriptFailure()).append(",");
        }
        if (this.getExecutionTimeout() != null) {
            sb.append("ExecutionTimeout: ").append(this.getExecutionTimeout()).append(",");
        }
        if (this.getMaximumRetryCount() != null) {
            sb.append("MaximumRetryCount: ").append(this.getMaximumRetryCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Script)) {
            return false;
        }
        Script other = (Script)obj;
        if (other.getStages() == null ^ this.getStages() == null) {
            return false;
        }
        if (other.getStages() != null && !other.getStages().equals(this.getStages())) {
            return false;
        }
        if (other.getExecutionHandlerService() == null ^ this.getExecutionHandlerService() == null) {
            return false;
        }
        if (other.getExecutionHandlerService() != null && !other.getExecutionHandlerService().equals(this.getExecutionHandlerService())) {
            return false;
        }
        if (other.getExecutionHandler() == null ^ this.getExecutionHandler() == null) {
            return false;
        }
        if (other.getExecutionHandler() != null && !other.getExecutionHandler().equals(this.getExecutionHandler())) {
            return false;
        }
        if (other.getExecuteOperationOnScriptFailure() == null ^ this.getExecuteOperationOnScriptFailure() == null) {
            return false;
        }
        if (other.getExecuteOperationOnScriptFailure() != null && !other.getExecuteOperationOnScriptFailure().equals(this.getExecuteOperationOnScriptFailure())) {
            return false;
        }
        if (other.getExecutionTimeout() == null ^ this.getExecutionTimeout() == null) {
            return false;
        }
        if (other.getExecutionTimeout() != null && !other.getExecutionTimeout().equals(this.getExecutionTimeout())) {
            return false;
        }
        if (other.getMaximumRetryCount() == null ^ this.getMaximumRetryCount() == null) {
            return false;
        }
        return other.getMaximumRetryCount() == null || other.getMaximumRetryCount().equals(this.getMaximumRetryCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStages() == null ? 0 : this.getStages().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionHandlerService() == null ? 0 : this.getExecutionHandlerService().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionHandler() == null ? 0 : this.getExecutionHandler().hashCode());
        hashCode = 31 * hashCode + (this.getExecuteOperationOnScriptFailure() == null ? 0 : this.getExecuteOperationOnScriptFailure().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionTimeout() == null ? 0 : this.getExecutionTimeout().hashCode());
        hashCode = 31 * hashCode + (this.getMaximumRetryCount() == null ? 0 : this.getMaximumRetryCount().hashCode());
        return hashCode;
    }

    public Script clone() {
        try {
            return (Script)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScriptMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

