/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dlm.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.dlm.model.Script;
import java.util.List;

@SdkInternalApi
public class ScriptMarshaller {
    private static final MarshallingInfo<List> STAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Stages").build();
    private static final MarshallingInfo<String> EXECUTIONHANDLERSERVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionHandlerService").build();
    private static final MarshallingInfo<String> EXECUTIONHANDLER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionHandler").build();
    private static final MarshallingInfo<Boolean> EXECUTEOPERATIONONSCRIPTFAILURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecuteOperationOnScriptFailure").build();
    private static final MarshallingInfo<Integer> EXECUTIONTIMEOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionTimeout").build();
    private static final MarshallingInfo<Integer> MAXIMUMRETRYCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaximumRetryCount").build();
    private static final ScriptMarshaller instance = new ScriptMarshaller();

    public static ScriptMarshaller getInstance() {
        return instance;
    }

    public void marshall(Script script, ProtocolMarshaller protocolMarshaller) {
        if (script == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(script.getStages(), STAGES_BINDING);
            protocolMarshaller.marshall((Object)script.getExecutionHandlerService(), EXECUTIONHANDLERSERVICE_BINDING);
            protocolMarshaller.marshall((Object)script.getExecutionHandler(), EXECUTIONHANDLER_BINDING);
            protocolMarshaller.marshall((Object)script.getExecuteOperationOnScriptFailure(), EXECUTEOPERATIONONSCRIPTFAILURE_BINDING);
            protocolMarshaller.marshall((Object)script.getExecutionTimeout(), EXECUTIONTIMEOUT_BINDING);
            protocolMarshaller.marshall((Object)script.getMaximumRetryCount(), MAXIMUMRETRYCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

