/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationdiscovery.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.applicationdiscovery.model.TagFilter;
import java.util.List;

public class TagFilterJsonMarshaller {
    private static TagFilterJsonMarshaller instance;

    public void marshall(TagFilter tagFilter, StructuredJsonGenerator jsonGenerator) {
        if (tagFilter == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> valuesList;
            jsonGenerator.writeStartObject();
            if (tagFilter.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(tagFilter.getName());
            }
            if ((valuesList = tagFilter.getValues()) != null) {
                jsonGenerator.writeFieldName("values");
                jsonGenerator.writeStartArray();
                for (String valuesListValue : valuesList) {
                    if (valuesListValue == null) continue;
                    jsonGenerator.writeValue(valuesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TagFilterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TagFilterJsonMarshaller();
        }
        return instance;
    }
}

