/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.directconnect.model.RouterType;

@SdkInternalApi
public class RouterTypeMarshaller {
    private static final MarshallingInfo<String> VENDOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vendor").build();
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platform").build();
    private static final MarshallingInfo<String> SOFTWARE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("software").build();
    private static final MarshallingInfo<String> XSLTTEMPLATENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("xsltTemplateName").build();
    private static final MarshallingInfo<String> XSLTTEMPLATENAMEFORMACSEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("xsltTemplateNameForMacSec").build();
    private static final MarshallingInfo<String> ROUTERTYPEIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("routerTypeIdentifier").build();
    private static final RouterTypeMarshaller instance = new RouterTypeMarshaller();

    public static RouterTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(RouterType routerType, ProtocolMarshaller protocolMarshaller) {
        if (routerType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)routerType.getVendor(), VENDOR_BINDING);
            protocolMarshaller.marshall((Object)routerType.getPlatform(), PLATFORM_BINDING);
            protocolMarshaller.marshall((Object)routerType.getSoftware(), SOFTWARE_BINDING);
            protocolMarshaller.marshall((Object)routerType.getXsltTemplateName(), XSLTTEMPLATENAME_BINDING);
            protocolMarshaller.marshall((Object)routerType.getXsltTemplateNameForMacSec(), XSLTTEMPLATENAMEFORMACSEC_BINDING);
            protocolMarshaller.marshall((Object)routerType.getRouterTypeIdentifier(), ROUTERTYPEIDENTIFIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

