/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.directconnect.model.Interconnect;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class InterconnectMarshaller {
    private static final MarshallingInfo<String> INTERCONNECTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("interconnectId").build();
    private static final MarshallingInfo<String> INTERCONNECTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("interconnectName").build();
    private static final MarshallingInfo<String> INTERCONNECTSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("interconnectState").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("region").build();
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<String> BANDWIDTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bandwidth").build();
    private static final MarshallingInfo<Date> LOAISSUETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loaIssueTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> LAGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lagId").build();
    private static final MarshallingInfo<String> AWSDEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsDevice").build();
    private static final MarshallingInfo<Boolean> JUMBOFRAMECAPABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jumboFrameCapable").build();
    private static final MarshallingInfo<String> AWSDEVICEV2_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsDeviceV2").build();
    private static final MarshallingInfo<String> AWSLOGICALDEVICEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsLogicalDeviceId").build();
    private static final MarshallingInfo<String> HASLOGICALREDUNDANCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hasLogicalRedundancy").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<String> PROVIDERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("providerName").build();
    private static final InterconnectMarshaller instance = new InterconnectMarshaller();

    public static InterconnectMarshaller getInstance() {
        return instance;
    }

    public void marshall(Interconnect interconnect, ProtocolMarshaller protocolMarshaller) {
        if (interconnect == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)interconnect.getInterconnectId(), INTERCONNECTID_BINDING);
            protocolMarshaller.marshall((Object)interconnect.getInterconnectName(), INTERCONNECTNAME_BINDING);
            protocolMarshaller.marshall((Object)interconnect.getInterconnectState(), INTERCONNECTSTATE_BINDING);
            protocolMarshaller.marshall((Object)interconnect.getRegion(), REGION_BINDING);
            protocolMarshaller.marshall((Object)interconnect.getLocation(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)interconnect.getBandwidth(), BANDWIDTH_BINDING);
            protocolMarshaller.marshall((Object)interconnect.getLoaIssueTime(), LOAISSUETIME_BINDING);
            protocolMarshaller.marshall((Object)interconnect.getLagId(), LAGID_BINDING);
            protocolMarshaller.marshall((Object)interconnect.getAwsDevice(), AWSDEVICE_BINDING);
            protocolMarshaller.marshall((Object)interconnect.getJumboFrameCapable(), JUMBOFRAMECAPABLE_BINDING);
            protocolMarshaller.marshall((Object)interconnect.getAwsDeviceV2(), AWSDEVICEV2_BINDING);
            protocolMarshaller.marshall((Object)interconnect.getAwsLogicalDeviceId(), AWSLOGICALDEVICEID_BINDING);
            protocolMarshaller.marshall((Object)interconnect.getHasLogicalRedundancy(), HASLOGICALREDUNDANCY_BINDING);
            protocolMarshaller.marshall(interconnect.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)interconnect.getProviderName(), PROVIDERNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

