/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directconnect.model.DescribeLoaRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeLoaRequestMarshaller
implements Marshaller<Request<DescribeLoaRequest>, DescribeLoaRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeLoaRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeLoaRequest> marshall(DescribeLoaRequest describeLoaRequest) {
        if (describeLoaRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeLoaRequest, "AmazonDirectConnect");
        request.addHeader("X-Amz-Target", "OvertureService.DescribeLoa");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeLoaRequest.getConnectionId() != null) {
                jsonGenerator.writeFieldName("connectionId").writeValue(describeLoaRequest.getConnectionId());
            }
            if (describeLoaRequest.getProviderName() != null) {
                jsonGenerator.writeFieldName("providerName").writeValue(describeLoaRequest.getProviderName());
            }
            if (describeLoaRequest.getLoaContentType() != null) {
                jsonGenerator.writeFieldName("loaContentType").writeValue(describeLoaRequest.getLoaContentType());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

