/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directconnect.model.CreateConnectionRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateConnectionRequestMarshaller
implements Marshaller<Request<CreateConnectionRequest>, CreateConnectionRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateConnectionRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateConnectionRequest> marshall(CreateConnectionRequest createConnectionRequest) {
        if (createConnectionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createConnectionRequest, "AmazonDirectConnect");
        request.addHeader("X-Amz-Target", "OvertureService.CreateConnection");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createConnectionRequest.getLocation() != null) {
                jsonGenerator.writeFieldName("location").writeValue(createConnectionRequest.getLocation());
            }
            if (createConnectionRequest.getBandwidth() != null) {
                jsonGenerator.writeFieldName("bandwidth").writeValue(createConnectionRequest.getBandwidth());
            }
            if (createConnectionRequest.getConnectionName() != null) {
                jsonGenerator.writeFieldName("connectionName").writeValue(createConnectionRequest.getConnectionName());
            }
            if (createConnectionRequest.getLagId() != null) {
                jsonGenerator.writeFieldName("lagId").writeValue(createConnectionRequest.getLagId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

