/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directconnect.model.AllocateHostedConnectionRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class AllocateHostedConnectionRequestMarshaller
implements Marshaller<Request<AllocateHostedConnectionRequest>, AllocateHostedConnectionRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public AllocateHostedConnectionRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<AllocateHostedConnectionRequest> marshall(AllocateHostedConnectionRequest allocateHostedConnectionRequest) {
        if (allocateHostedConnectionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)allocateHostedConnectionRequest, "AmazonDirectConnect");
        request.addHeader("X-Amz-Target", "OvertureService.AllocateHostedConnection");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (allocateHostedConnectionRequest.getConnectionId() != null) {
                jsonGenerator.writeFieldName("connectionId").writeValue(allocateHostedConnectionRequest.getConnectionId());
            }
            if (allocateHostedConnectionRequest.getOwnerAccount() != null) {
                jsonGenerator.writeFieldName("ownerAccount").writeValue(allocateHostedConnectionRequest.getOwnerAccount());
            }
            if (allocateHostedConnectionRequest.getBandwidth() != null) {
                jsonGenerator.writeFieldName("bandwidth").writeValue(allocateHostedConnectionRequest.getBandwidth());
            }
            if (allocateHostedConnectionRequest.getConnectionName() != null) {
                jsonGenerator.writeFieldName("connectionName").writeValue(allocateHostedConnectionRequest.getConnectionName());
            }
            if (allocateHostedConnectionRequest.getVlan() != null) {
                jsonGenerator.writeFieldName("vlan").writeValue(allocateHostedConnectionRequest.getVlan().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

