/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devopsguru.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.devopsguru.model.InsightSeverity;
import com.amazonaws.services.devopsguru.model.NotificationMessageType;
import com.amazonaws.services.devopsguru.model.transform.NotificationFilterConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NotificationFilterConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> severities;
    private List<String> messageTypes;

    public List<String> getSeverities() {
        return this.severities;
    }

    public void setSeverities(Collection<String> severities) {
        if (severities == null) {
            this.severities = null;
            return;
        }
        this.severities = new ArrayList<String>(severities);
    }

    public NotificationFilterConfig withSeverities(String ... severities) {
        if (this.severities == null) {
            this.setSeverities(new ArrayList<String>(severities.length));
        }
        for (String ele : severities) {
            this.severities.add(ele);
        }
        return this;
    }

    public NotificationFilterConfig withSeverities(Collection<String> severities) {
        this.setSeverities(severities);
        return this;
    }

    public NotificationFilterConfig withSeverities(InsightSeverity ... severities) {
        ArrayList<String> severitiesCopy = new ArrayList<String>(severities.length);
        for (InsightSeverity value : severities) {
            severitiesCopy.add(value.toString());
        }
        if (this.getSeverities() == null) {
            this.setSeverities(severitiesCopy);
        } else {
            this.getSeverities().addAll(severitiesCopy);
        }
        return this;
    }

    public List<String> getMessageTypes() {
        return this.messageTypes;
    }

    public void setMessageTypes(Collection<String> messageTypes) {
        if (messageTypes == null) {
            this.messageTypes = null;
            return;
        }
        this.messageTypes = new ArrayList<String>(messageTypes);
    }

    public NotificationFilterConfig withMessageTypes(String ... messageTypes) {
        if (this.messageTypes == null) {
            this.setMessageTypes(new ArrayList<String>(messageTypes.length));
        }
        for (String ele : messageTypes) {
            this.messageTypes.add(ele);
        }
        return this;
    }

    public NotificationFilterConfig withMessageTypes(Collection<String> messageTypes) {
        this.setMessageTypes(messageTypes);
        return this;
    }

    public NotificationFilterConfig withMessageTypes(NotificationMessageType ... messageTypes) {
        ArrayList<String> messageTypesCopy = new ArrayList<String>(messageTypes.length);
        for (NotificationMessageType value : messageTypes) {
            messageTypesCopy.add(value.toString());
        }
        if (this.getMessageTypes() == null) {
            this.setMessageTypes(messageTypesCopy);
        } else {
            this.getMessageTypes().addAll(messageTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSeverities() != null) {
            sb.append("Severities: ").append(this.getSeverities()).append(",");
        }
        if (this.getMessageTypes() != null) {
            sb.append("MessageTypes: ").append(this.getMessageTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationFilterConfig)) {
            return false;
        }
        NotificationFilterConfig other = (NotificationFilterConfig)obj;
        if (other.getSeverities() == null ^ this.getSeverities() == null) {
            return false;
        }
        if (other.getSeverities() != null && !other.getSeverities().equals(this.getSeverities())) {
            return false;
        }
        if (other.getMessageTypes() == null ^ this.getMessageTypes() == null) {
            return false;
        }
        return other.getMessageTypes() == null || other.getMessageTypes().equals(this.getMessageTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSeverities() == null ? 0 : this.getSeverities().hashCode());
        hashCode = 31 * hashCode + (this.getMessageTypes() == null ? 0 : this.getMessageTypes().hashCode());
        return hashCode;
    }

    public NotificationFilterConfig clone() {
        try {
            return (NotificationFilterConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotificationFilterConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

