/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.devicefarm.model.Test;
import com.amazonaws.services.devicefarm.model.transform.CountersJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.DeviceMinutesJsonMarshaller;

public class TestJsonMarshaller {
    private static TestJsonMarshaller instance;

    public void marshall(Test test, StructuredJsonGenerator jsonGenerator) {
        if (test == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (test.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(test.getArn());
            }
            if (test.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(test.getName());
            }
            if (test.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(test.getType());
            }
            if (test.getCreated() != null) {
                jsonGenerator.writeFieldName("created").writeValue(test.getCreated());
            }
            if (test.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(test.getStatus());
            }
            if (test.getResult() != null) {
                jsonGenerator.writeFieldName("result").writeValue(test.getResult());
            }
            if (test.getStarted() != null) {
                jsonGenerator.writeFieldName("started").writeValue(test.getStarted());
            }
            if (test.getStopped() != null) {
                jsonGenerator.writeFieldName("stopped").writeValue(test.getStopped());
            }
            if (test.getCounters() != null) {
                jsonGenerator.writeFieldName("counters");
                CountersJsonMarshaller.getInstance().marshall(test.getCounters(), jsonGenerator);
            }
            if (test.getMessage() != null) {
                jsonGenerator.writeFieldName("message").writeValue(test.getMessage());
            }
            if (test.getDeviceMinutes() != null) {
                jsonGenerator.writeFieldName("deviceMinutes");
                DeviceMinutesJsonMarshaller.getInstance().marshall(test.getDeviceMinutes(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TestJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TestJsonMarshaller();
        }
        return instance;
    }
}

