/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.devicefarm.model.DeviceFilter;
import com.amazonaws.services.devicefarm.model.transform.DeviceSelectionResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeviceSelectionResult
implements Serializable,
Cloneable,
StructuredPojo {
    private List<DeviceFilter> filters;
    private Integer matchedDevicesCount;
    private Integer maxDevices;

    public List<DeviceFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<DeviceFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<DeviceFilter>(filters);
    }

    public DeviceSelectionResult withFilters(DeviceFilter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<DeviceFilter>(filters.length));
        }
        for (DeviceFilter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public DeviceSelectionResult withFilters(Collection<DeviceFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setMatchedDevicesCount(Integer matchedDevicesCount) {
        this.matchedDevicesCount = matchedDevicesCount;
    }

    public Integer getMatchedDevicesCount() {
        return this.matchedDevicesCount;
    }

    public DeviceSelectionResult withMatchedDevicesCount(Integer matchedDevicesCount) {
        this.setMatchedDevicesCount(matchedDevicesCount);
        return this;
    }

    public void setMaxDevices(Integer maxDevices) {
        this.maxDevices = maxDevices;
    }

    public Integer getMaxDevices() {
        return this.maxDevices;
    }

    public DeviceSelectionResult withMaxDevices(Integer maxDevices) {
        this.setMaxDevices(maxDevices);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getMatchedDevicesCount() != null) {
            sb.append("MatchedDevicesCount: ").append(this.getMatchedDevicesCount()).append(",");
        }
        if (this.getMaxDevices() != null) {
            sb.append("MaxDevices: ").append(this.getMaxDevices());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceSelectionResult)) {
            return false;
        }
        DeviceSelectionResult other = (DeviceSelectionResult)obj;
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getMatchedDevicesCount() == null ^ this.getMatchedDevicesCount() == null) {
            return false;
        }
        if (other.getMatchedDevicesCount() != null && !other.getMatchedDevicesCount().equals(this.getMatchedDevicesCount())) {
            return false;
        }
        if (other.getMaxDevices() == null ^ this.getMaxDevices() == null) {
            return false;
        }
        return other.getMaxDevices() == null || other.getMaxDevices().equals(this.getMaxDevices());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getMatchedDevicesCount() == null ? 0 : this.getMatchedDevicesCount().hashCode());
        hashCode = 31 * hashCode + (this.getMaxDevices() == null ? 0 : this.getMaxDevices().hashCode());
        return hashCode;
    }

    public DeviceSelectionResult clone() {
        try {
            return (DeviceSelectionResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceSelectionResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

