/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.devicefarm.model.DevicePoolCompatibilityResult;
import com.amazonaws.services.devicefarm.model.IncompatibilityMessage;
import com.amazonaws.services.devicefarm.model.transform.DeviceJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.IncompatibilityMessageJsonMarshaller;
import java.util.List;

public class DevicePoolCompatibilityResultJsonMarshaller {
    private static DevicePoolCompatibilityResultJsonMarshaller instance;

    public void marshall(DevicePoolCompatibilityResult devicePoolCompatibilityResult, StructuredJsonGenerator jsonGenerator) {
        if (devicePoolCompatibilityResult == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<IncompatibilityMessage> incompatibilityMessagesList;
            jsonGenerator.writeStartObject();
            if (devicePoolCompatibilityResult.getDevice() != null) {
                jsonGenerator.writeFieldName("device");
                DeviceJsonMarshaller.getInstance().marshall(devicePoolCompatibilityResult.getDevice(), jsonGenerator);
            }
            if (devicePoolCompatibilityResult.getCompatible() != null) {
                jsonGenerator.writeFieldName("compatible").writeValue(devicePoolCompatibilityResult.getCompatible().booleanValue());
            }
            if ((incompatibilityMessagesList = devicePoolCompatibilityResult.getIncompatibilityMessages()) != null) {
                jsonGenerator.writeFieldName("incompatibilityMessages");
                jsonGenerator.writeStartArray();
                for (IncompatibilityMessage incompatibilityMessagesListValue : incompatibilityMessagesList) {
                    if (incompatibilityMessagesListValue == null) continue;
                    IncompatibilityMessageJsonMarshaller.getInstance().marshall(incompatibilityMessagesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DevicePoolCompatibilityResultJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DevicePoolCompatibilityResultJsonMarshaller();
        }
        return instance;
    }
}

