/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.devicefarm.model.DevicePool;
import com.amazonaws.services.devicefarm.model.Rule;
import com.amazonaws.services.devicefarm.model.transform.RuleJsonMarshaller;
import java.util.List;

public class DevicePoolJsonMarshaller {
    private static DevicePoolJsonMarshaller instance;

    public void marshall(DevicePool devicePool, StructuredJsonGenerator jsonGenerator) {
        if (devicePool == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Rule> rulesList;
            jsonGenerator.writeStartObject();
            if (devicePool.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(devicePool.getArn());
            }
            if (devicePool.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(devicePool.getName());
            }
            if (devicePool.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(devicePool.getDescription());
            }
            if (devicePool.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(devicePool.getType());
            }
            if ((rulesList = devicePool.getRules()) != null) {
                jsonGenerator.writeFieldName("rules");
                jsonGenerator.writeStartArray();
                for (Rule rulesListValue : rulesList) {
                    if (rulesListValue == null) continue;
                    RuleJsonMarshaller.getInstance().marshall(rulesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DevicePoolJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DevicePoolJsonMarshaller();
        }
        return instance;
    }
}

