/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.devicefarm.model.Problem;
import com.amazonaws.services.devicefarm.model.UniqueProblem;
import com.amazonaws.services.devicefarm.model.transform.ProblemJsonMarshaller;
import java.util.List;

public class UniqueProblemJsonMarshaller {
    private static UniqueProblemJsonMarshaller instance;

    public void marshall(UniqueProblem uniqueProblem, StructuredJsonGenerator jsonGenerator) {
        if (uniqueProblem == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Problem> problemsList;
            jsonGenerator.writeStartObject();
            if (uniqueProblem.getMessage() != null) {
                jsonGenerator.writeFieldName("message").writeValue(uniqueProblem.getMessage());
            }
            if ((problemsList = uniqueProblem.getProblems()) != null) {
                jsonGenerator.writeFieldName("problems");
                jsonGenerator.writeStartArray();
                for (Problem problemsListValue : problemsList) {
                    if (problemsListValue == null) continue;
                    ProblemJsonMarshaller.getInstance().marshall(problemsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static UniqueProblemJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new UniqueProblemJsonMarshaller();
        }
        return instance;
    }
}

