/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.devicefarm.model.ScheduleRunConfiguration;
import com.amazonaws.services.devicefarm.model.transform.LocationJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.RadiosJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.List;

public class ScheduleRunConfigurationJsonMarshaller {
    private static ScheduleRunConfigurationJsonMarshaller instance;

    public void marshall(ScheduleRunConfiguration scheduleRunConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (scheduleRunConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> auxiliaryAppsList;
            jsonGenerator.writeStartObject();
            if (scheduleRunConfiguration.getExtraDataPackageArn() != null) {
                jsonGenerator.writeFieldName("extraDataPackageArn").writeValue(scheduleRunConfiguration.getExtraDataPackageArn());
            }
            if (scheduleRunConfiguration.getNetworkProfileArn() != null) {
                jsonGenerator.writeFieldName("networkProfileArn").writeValue(scheduleRunConfiguration.getNetworkProfileArn());
            }
            if (scheduleRunConfiguration.getLocale() != null) {
                jsonGenerator.writeFieldName("locale").writeValue(scheduleRunConfiguration.getLocale());
            }
            if (scheduleRunConfiguration.getLocation() != null) {
                jsonGenerator.writeFieldName("location");
                LocationJsonMarshaller.getInstance().marshall(scheduleRunConfiguration.getLocation(), jsonGenerator);
            }
            if (scheduleRunConfiguration.getRadios() != null) {
                jsonGenerator.writeFieldName("radios");
                RadiosJsonMarshaller.getInstance().marshall(scheduleRunConfiguration.getRadios(), jsonGenerator);
            }
            if ((auxiliaryAppsList = scheduleRunConfiguration.getAuxiliaryApps()) != null) {
                jsonGenerator.writeFieldName("auxiliaryApps");
                jsonGenerator.writeStartArray();
                for (String auxiliaryAppsListValue : auxiliaryAppsList) {
                    if (auxiliaryAppsListValue == null) continue;
                    jsonGenerator.writeValue(auxiliaryAppsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (scheduleRunConfiguration.getBillingMethod() != null) {
                jsonGenerator.writeFieldName("billingMethod").writeValue(scheduleRunConfiguration.getBillingMethod());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ScheduleRunConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ScheduleRunConfigurationJsonMarshaller();
        }
        return instance;
    }
}

