/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.devicefarm.model.ScheduleRunRequest;
import com.amazonaws.services.devicefarm.model.transform.ScheduleRunConfigurationJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.ScheduleRunTestJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ScheduleRunRequestMarshaller
implements Marshaller<Request<ScheduleRunRequest>, ScheduleRunRequest> {
    public Request<ScheduleRunRequest> marshall(ScheduleRunRequest scheduleRunRequest) {
        if (scheduleRunRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)scheduleRunRequest, "AWSDeviceFarm");
        request.addHeader("X-Amz-Target", "DeviceFarm_20150623.ScheduleRun");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (scheduleRunRequest.getProjectArn() != null) {
                jsonGenerator.writeFieldName("projectArn").writeValue(scheduleRunRequest.getProjectArn());
            }
            if (scheduleRunRequest.getAppArn() != null) {
                jsonGenerator.writeFieldName("appArn").writeValue(scheduleRunRequest.getAppArn());
            }
            if (scheduleRunRequest.getDevicePoolArn() != null) {
                jsonGenerator.writeFieldName("devicePoolArn").writeValue(scheduleRunRequest.getDevicePoolArn());
            }
            if (scheduleRunRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(scheduleRunRequest.getName());
            }
            if (scheduleRunRequest.getTest() != null) {
                jsonGenerator.writeFieldName("test");
                ScheduleRunTestJsonMarshaller.getInstance().marshall(scheduleRunRequest.getTest(), jsonGenerator);
            }
            if (scheduleRunRequest.getConfiguration() != null) {
                jsonGenerator.writeFieldName("configuration");
                ScheduleRunConfigurationJsonMarshaller.getInstance().marshall(scheduleRunRequest.getConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

