/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.devicefarm.model.Offering;
import com.amazonaws.services.devicefarm.model.RecurringCharge;
import com.amazonaws.services.devicefarm.model.transform.RecurringChargeJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.util.List;

public class OfferingJsonMarshaller {
    private static OfferingJsonMarshaller instance;

    public void marshall(Offering offering, SdkJsonGenerator jsonGenerator) {
        if (offering == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<RecurringCharge> recurringChargesList;
            jsonGenerator.writeStartObject();
            if (offering.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(offering.getId());
            }
            if (offering.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(offering.getDescription());
            }
            if (offering.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(offering.getType());
            }
            if (offering.getPlatform() != null) {
                jsonGenerator.writeFieldName("platform").writeValue(offering.getPlatform());
            }
            if ((recurringChargesList = offering.getRecurringCharges()) != null) {
                jsonGenerator.writeFieldName("recurringCharges");
                jsonGenerator.writeStartArray();
                for (RecurringCharge recurringChargesListValue : recurringChargesList) {
                    if (recurringChargesListValue == null) continue;
                    RecurringChargeJsonMarshaller.getInstance().marshall(recurringChargesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static OfferingJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new OfferingJsonMarshaller();
        }
        return instance;
    }
}

