/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.devicefarm.model.DevicePool;
import com.amazonaws.services.devicefarm.model.Rule;
import com.amazonaws.services.devicefarm.model.transform.RuleJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.util.List;

public class DevicePoolJsonMarshaller {
    private static DevicePoolJsonMarshaller instance;

    public void marshall(DevicePool devicePool, SdkJsonGenerator jsonGenerator) {
        if (devicePool == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Rule> rulesList;
            jsonGenerator.writeStartObject();
            if (devicePool.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(devicePool.getArn());
            }
            if (devicePool.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(devicePool.getName());
            }
            if (devicePool.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(devicePool.getDescription());
            }
            if (devicePool.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(devicePool.getType());
            }
            if ((rulesList = devicePool.getRules()) != null) {
                jsonGenerator.writeFieldName("rules");
                jsonGenerator.writeStartArray();
                for (Rule rulesListValue : rulesList) {
                    if (rulesListValue == null) continue;
                    RuleJsonMarshaller.getInstance().marshall(rulesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DevicePoolJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DevicePoolJsonMarshaller();
        }
        return instance;
    }
}

