/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.devicefarm.AWSDeviceFarmAsync;
import com.amazonaws.services.devicefarm.AWSDeviceFarmClient;
import com.amazonaws.services.devicefarm.model.CreateDevicePoolRequest;
import com.amazonaws.services.devicefarm.model.CreateDevicePoolResult;
import com.amazonaws.services.devicefarm.model.CreateProjectRequest;
import com.amazonaws.services.devicefarm.model.CreateProjectResult;
import com.amazonaws.services.devicefarm.model.CreateUploadRequest;
import com.amazonaws.services.devicefarm.model.CreateUploadResult;
import com.amazonaws.services.devicefarm.model.GetDevicePoolCompatibilityRequest;
import com.amazonaws.services.devicefarm.model.GetDevicePoolCompatibilityResult;
import com.amazonaws.services.devicefarm.model.GetDevicePoolRequest;
import com.amazonaws.services.devicefarm.model.GetDevicePoolResult;
import com.amazonaws.services.devicefarm.model.GetDeviceRequest;
import com.amazonaws.services.devicefarm.model.GetDeviceResult;
import com.amazonaws.services.devicefarm.model.GetJobRequest;
import com.amazonaws.services.devicefarm.model.GetJobResult;
import com.amazonaws.services.devicefarm.model.GetProjectRequest;
import com.amazonaws.services.devicefarm.model.GetProjectResult;
import com.amazonaws.services.devicefarm.model.GetRunRequest;
import com.amazonaws.services.devicefarm.model.GetRunResult;
import com.amazonaws.services.devicefarm.model.GetSuiteRequest;
import com.amazonaws.services.devicefarm.model.GetSuiteResult;
import com.amazonaws.services.devicefarm.model.GetTestRequest;
import com.amazonaws.services.devicefarm.model.GetTestResult;
import com.amazonaws.services.devicefarm.model.GetUploadRequest;
import com.amazonaws.services.devicefarm.model.GetUploadResult;
import com.amazonaws.services.devicefarm.model.ListArtifactsRequest;
import com.amazonaws.services.devicefarm.model.ListArtifactsResult;
import com.amazonaws.services.devicefarm.model.ListDevicePoolsRequest;
import com.amazonaws.services.devicefarm.model.ListDevicePoolsResult;
import com.amazonaws.services.devicefarm.model.ListDevicesRequest;
import com.amazonaws.services.devicefarm.model.ListDevicesResult;
import com.amazonaws.services.devicefarm.model.ListJobsRequest;
import com.amazonaws.services.devicefarm.model.ListJobsResult;
import com.amazonaws.services.devicefarm.model.ListProjectsRequest;
import com.amazonaws.services.devicefarm.model.ListProjectsResult;
import com.amazonaws.services.devicefarm.model.ListRunsRequest;
import com.amazonaws.services.devicefarm.model.ListRunsResult;
import com.amazonaws.services.devicefarm.model.ListSamplesRequest;
import com.amazonaws.services.devicefarm.model.ListSamplesResult;
import com.amazonaws.services.devicefarm.model.ListSuitesRequest;
import com.amazonaws.services.devicefarm.model.ListSuitesResult;
import com.amazonaws.services.devicefarm.model.ListTestsRequest;
import com.amazonaws.services.devicefarm.model.ListTestsResult;
import com.amazonaws.services.devicefarm.model.ListUniqueProblemsRequest;
import com.amazonaws.services.devicefarm.model.ListUniqueProblemsResult;
import com.amazonaws.services.devicefarm.model.ListUploadsRequest;
import com.amazonaws.services.devicefarm.model.ListUploadsResult;
import com.amazonaws.services.devicefarm.model.ScheduleRunRequest;
import com.amazonaws.services.devicefarm.model.ScheduleRunResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AWSDeviceFarmAsyncClient
extends AWSDeviceFarmClient
implements AWSDeviceFarmAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSDeviceFarmAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AWSDeviceFarmAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSDeviceFarmAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSDeviceFarmAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, new ClientConfiguration(), executorService);
    }

    public AWSDeviceFarmAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSDeviceFarmAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSDeviceFarmAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSDeviceFarmAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AWSDeviceFarmAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<CreateDevicePoolResult> createDevicePoolAsync(final CreateDevicePoolRequest createDevicePoolRequest) {
        return this.executorService.submit(new Callable<CreateDevicePoolResult>(){

            @Override
            public CreateDevicePoolResult call() {
                return AWSDeviceFarmAsyncClient.this.createDevicePool(createDevicePoolRequest);
            }
        });
    }

    @Override
    public Future<CreateDevicePoolResult> createDevicePoolAsync(final CreateDevicePoolRequest createDevicePoolRequest, final AsyncHandler<CreateDevicePoolRequest, CreateDevicePoolResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateDevicePoolResult>(){

            @Override
            public CreateDevicePoolResult call() throws Exception {
                CreateDevicePoolResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.createDevicePool(createDevicePoolRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createDevicePoolRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateProjectResult> createProjectAsync(final CreateProjectRequest createProjectRequest) {
        return this.executorService.submit(new Callable<CreateProjectResult>(){

            @Override
            public CreateProjectResult call() {
                return AWSDeviceFarmAsyncClient.this.createProject(createProjectRequest);
            }
        });
    }

    @Override
    public Future<CreateProjectResult> createProjectAsync(final CreateProjectRequest createProjectRequest, final AsyncHandler<CreateProjectRequest, CreateProjectResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateProjectResult>(){

            @Override
            public CreateProjectResult call() throws Exception {
                CreateProjectResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.createProject(createProjectRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createProjectRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateUploadResult> createUploadAsync(final CreateUploadRequest createUploadRequest) {
        return this.executorService.submit(new Callable<CreateUploadResult>(){

            @Override
            public CreateUploadResult call() {
                return AWSDeviceFarmAsyncClient.this.createUpload(createUploadRequest);
            }
        });
    }

    @Override
    public Future<CreateUploadResult> createUploadAsync(final CreateUploadRequest createUploadRequest, final AsyncHandler<CreateUploadRequest, CreateUploadResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateUploadResult>(){

            @Override
            public CreateUploadResult call() throws Exception {
                CreateUploadResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.createUpload(createUploadRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createUploadRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetDeviceResult> getDeviceAsync(final GetDeviceRequest getDeviceRequest) {
        return this.executorService.submit(new Callable<GetDeviceResult>(){

            @Override
            public GetDeviceResult call() {
                return AWSDeviceFarmAsyncClient.this.getDevice(getDeviceRequest);
            }
        });
    }

    @Override
    public Future<GetDeviceResult> getDeviceAsync(final GetDeviceRequest getDeviceRequest, final AsyncHandler<GetDeviceRequest, GetDeviceResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetDeviceResult>(){

            @Override
            public GetDeviceResult call() throws Exception {
                GetDeviceResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getDevice(getDeviceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getDeviceRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetDevicePoolResult> getDevicePoolAsync(final GetDevicePoolRequest getDevicePoolRequest) {
        return this.executorService.submit(new Callable<GetDevicePoolResult>(){

            @Override
            public GetDevicePoolResult call() {
                return AWSDeviceFarmAsyncClient.this.getDevicePool(getDevicePoolRequest);
            }
        });
    }

    @Override
    public Future<GetDevicePoolResult> getDevicePoolAsync(final GetDevicePoolRequest getDevicePoolRequest, final AsyncHandler<GetDevicePoolRequest, GetDevicePoolResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetDevicePoolResult>(){

            @Override
            public GetDevicePoolResult call() throws Exception {
                GetDevicePoolResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getDevicePool(getDevicePoolRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getDevicePoolRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetDevicePoolCompatibilityResult> getDevicePoolCompatibilityAsync(final GetDevicePoolCompatibilityRequest getDevicePoolCompatibilityRequest) {
        return this.executorService.submit(new Callable<GetDevicePoolCompatibilityResult>(){

            @Override
            public GetDevicePoolCompatibilityResult call() {
                return AWSDeviceFarmAsyncClient.this.getDevicePoolCompatibility(getDevicePoolCompatibilityRequest);
            }
        });
    }

    @Override
    public Future<GetDevicePoolCompatibilityResult> getDevicePoolCompatibilityAsync(final GetDevicePoolCompatibilityRequest getDevicePoolCompatibilityRequest, final AsyncHandler<GetDevicePoolCompatibilityRequest, GetDevicePoolCompatibilityResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetDevicePoolCompatibilityResult>(){

            @Override
            public GetDevicePoolCompatibilityResult call() throws Exception {
                GetDevicePoolCompatibilityResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getDevicePoolCompatibility(getDevicePoolCompatibilityRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getDevicePoolCompatibilityRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetJobResult> getJobAsync(final GetJobRequest getJobRequest) {
        return this.executorService.submit(new Callable<GetJobResult>(){

            @Override
            public GetJobResult call() {
                return AWSDeviceFarmAsyncClient.this.getJob(getJobRequest);
            }
        });
    }

    @Override
    public Future<GetJobResult> getJobAsync(final GetJobRequest getJobRequest, final AsyncHandler<GetJobRequest, GetJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetJobResult>(){

            @Override
            public GetJobResult call() throws Exception {
                GetJobResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getJob(getJobRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getJobRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetProjectResult> getProjectAsync(final GetProjectRequest getProjectRequest) {
        return this.executorService.submit(new Callable<GetProjectResult>(){

            @Override
            public GetProjectResult call() {
                return AWSDeviceFarmAsyncClient.this.getProject(getProjectRequest);
            }
        });
    }

    @Override
    public Future<GetProjectResult> getProjectAsync(final GetProjectRequest getProjectRequest, final AsyncHandler<GetProjectRequest, GetProjectResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetProjectResult>(){

            @Override
            public GetProjectResult call() throws Exception {
                GetProjectResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getProject(getProjectRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getProjectRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetRunResult> getRunAsync(final GetRunRequest getRunRequest) {
        return this.executorService.submit(new Callable<GetRunResult>(){

            @Override
            public GetRunResult call() {
                return AWSDeviceFarmAsyncClient.this.getRun(getRunRequest);
            }
        });
    }

    @Override
    public Future<GetRunResult> getRunAsync(final GetRunRequest getRunRequest, final AsyncHandler<GetRunRequest, GetRunResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetRunResult>(){

            @Override
            public GetRunResult call() throws Exception {
                GetRunResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getRun(getRunRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getRunRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetSuiteResult> getSuiteAsync(final GetSuiteRequest getSuiteRequest) {
        return this.executorService.submit(new Callable<GetSuiteResult>(){

            @Override
            public GetSuiteResult call() {
                return AWSDeviceFarmAsyncClient.this.getSuite(getSuiteRequest);
            }
        });
    }

    @Override
    public Future<GetSuiteResult> getSuiteAsync(final GetSuiteRequest getSuiteRequest, final AsyncHandler<GetSuiteRequest, GetSuiteResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetSuiteResult>(){

            @Override
            public GetSuiteResult call() throws Exception {
                GetSuiteResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getSuite(getSuiteRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getSuiteRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetTestResult> getTestAsync(final GetTestRequest getTestRequest) {
        return this.executorService.submit(new Callable<GetTestResult>(){

            @Override
            public GetTestResult call() {
                return AWSDeviceFarmAsyncClient.this.getTest(getTestRequest);
            }
        });
    }

    @Override
    public Future<GetTestResult> getTestAsync(final GetTestRequest getTestRequest, final AsyncHandler<GetTestRequest, GetTestResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetTestResult>(){

            @Override
            public GetTestResult call() throws Exception {
                GetTestResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getTest(getTestRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getTestRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetUploadResult> getUploadAsync(final GetUploadRequest getUploadRequest) {
        return this.executorService.submit(new Callable<GetUploadResult>(){

            @Override
            public GetUploadResult call() {
                return AWSDeviceFarmAsyncClient.this.getUpload(getUploadRequest);
            }
        });
    }

    @Override
    public Future<GetUploadResult> getUploadAsync(final GetUploadRequest getUploadRequest, final AsyncHandler<GetUploadRequest, GetUploadResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetUploadResult>(){

            @Override
            public GetUploadResult call() throws Exception {
                GetUploadResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.getUpload(getUploadRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getUploadRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListArtifactsResult> listArtifactsAsync(final ListArtifactsRequest listArtifactsRequest) {
        return this.executorService.submit(new Callable<ListArtifactsResult>(){

            @Override
            public ListArtifactsResult call() {
                return AWSDeviceFarmAsyncClient.this.listArtifacts(listArtifactsRequest);
            }
        });
    }

    @Override
    public Future<ListArtifactsResult> listArtifactsAsync(final ListArtifactsRequest listArtifactsRequest, final AsyncHandler<ListArtifactsRequest, ListArtifactsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListArtifactsResult>(){

            @Override
            public ListArtifactsResult call() throws Exception {
                ListArtifactsResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listArtifacts(listArtifactsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listArtifactsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListDevicePoolsResult> listDevicePoolsAsync(final ListDevicePoolsRequest listDevicePoolsRequest) {
        return this.executorService.submit(new Callable<ListDevicePoolsResult>(){

            @Override
            public ListDevicePoolsResult call() {
                return AWSDeviceFarmAsyncClient.this.listDevicePools(listDevicePoolsRequest);
            }
        });
    }

    @Override
    public Future<ListDevicePoolsResult> listDevicePoolsAsync(final ListDevicePoolsRequest listDevicePoolsRequest, final AsyncHandler<ListDevicePoolsRequest, ListDevicePoolsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListDevicePoolsResult>(){

            @Override
            public ListDevicePoolsResult call() throws Exception {
                ListDevicePoolsResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listDevicePools(listDevicePoolsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listDevicePoolsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListDevicesResult> listDevicesAsync(final ListDevicesRequest listDevicesRequest) {
        return this.executorService.submit(new Callable<ListDevicesResult>(){

            @Override
            public ListDevicesResult call() {
                return AWSDeviceFarmAsyncClient.this.listDevices(listDevicesRequest);
            }
        });
    }

    @Override
    public Future<ListDevicesResult> listDevicesAsync(final ListDevicesRequest listDevicesRequest, final AsyncHandler<ListDevicesRequest, ListDevicesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListDevicesResult>(){

            @Override
            public ListDevicesResult call() throws Exception {
                ListDevicesResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listDevices(listDevicesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listDevicesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(final ListJobsRequest listJobsRequest) {
        return this.executorService.submit(new Callable<ListJobsResult>(){

            @Override
            public ListJobsResult call() {
                return AWSDeviceFarmAsyncClient.this.listJobs(listJobsRequest);
            }
        });
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(final ListJobsRequest listJobsRequest, final AsyncHandler<ListJobsRequest, ListJobsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListJobsResult>(){

            @Override
            public ListJobsResult call() throws Exception {
                ListJobsResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listJobs(listJobsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listJobsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListProjectsResult> listProjectsAsync(final ListProjectsRequest listProjectsRequest) {
        return this.executorService.submit(new Callable<ListProjectsResult>(){

            @Override
            public ListProjectsResult call() {
                return AWSDeviceFarmAsyncClient.this.listProjects(listProjectsRequest);
            }
        });
    }

    @Override
    public Future<ListProjectsResult> listProjectsAsync(final ListProjectsRequest listProjectsRequest, final AsyncHandler<ListProjectsRequest, ListProjectsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListProjectsResult>(){

            @Override
            public ListProjectsResult call() throws Exception {
                ListProjectsResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listProjects(listProjectsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listProjectsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListRunsResult> listRunsAsync(final ListRunsRequest listRunsRequest) {
        return this.executorService.submit(new Callable<ListRunsResult>(){

            @Override
            public ListRunsResult call() {
                return AWSDeviceFarmAsyncClient.this.listRuns(listRunsRequest);
            }
        });
    }

    @Override
    public Future<ListRunsResult> listRunsAsync(final ListRunsRequest listRunsRequest, final AsyncHandler<ListRunsRequest, ListRunsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListRunsResult>(){

            @Override
            public ListRunsResult call() throws Exception {
                ListRunsResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listRuns(listRunsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listRunsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListSamplesResult> listSamplesAsync(final ListSamplesRequest listSamplesRequest) {
        return this.executorService.submit(new Callable<ListSamplesResult>(){

            @Override
            public ListSamplesResult call() {
                return AWSDeviceFarmAsyncClient.this.listSamples(listSamplesRequest);
            }
        });
    }

    @Override
    public Future<ListSamplesResult> listSamplesAsync(final ListSamplesRequest listSamplesRequest, final AsyncHandler<ListSamplesRequest, ListSamplesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListSamplesResult>(){

            @Override
            public ListSamplesResult call() throws Exception {
                ListSamplesResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listSamples(listSamplesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listSamplesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListSuitesResult> listSuitesAsync(final ListSuitesRequest listSuitesRequest) {
        return this.executorService.submit(new Callable<ListSuitesResult>(){

            @Override
            public ListSuitesResult call() {
                return AWSDeviceFarmAsyncClient.this.listSuites(listSuitesRequest);
            }
        });
    }

    @Override
    public Future<ListSuitesResult> listSuitesAsync(final ListSuitesRequest listSuitesRequest, final AsyncHandler<ListSuitesRequest, ListSuitesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListSuitesResult>(){

            @Override
            public ListSuitesResult call() throws Exception {
                ListSuitesResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listSuites(listSuitesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listSuitesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTestsResult> listTestsAsync(final ListTestsRequest listTestsRequest) {
        return this.executorService.submit(new Callable<ListTestsResult>(){

            @Override
            public ListTestsResult call() {
                return AWSDeviceFarmAsyncClient.this.listTests(listTestsRequest);
            }
        });
    }

    @Override
    public Future<ListTestsResult> listTestsAsync(final ListTestsRequest listTestsRequest, final AsyncHandler<ListTestsRequest, ListTestsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTestsResult>(){

            @Override
            public ListTestsResult call() throws Exception {
                ListTestsResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listTests(listTestsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listTestsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListUniqueProblemsResult> listUniqueProblemsAsync(final ListUniqueProblemsRequest listUniqueProblemsRequest) {
        return this.executorService.submit(new Callable<ListUniqueProblemsResult>(){

            @Override
            public ListUniqueProblemsResult call() {
                return AWSDeviceFarmAsyncClient.this.listUniqueProblems(listUniqueProblemsRequest);
            }
        });
    }

    @Override
    public Future<ListUniqueProblemsResult> listUniqueProblemsAsync(final ListUniqueProblemsRequest listUniqueProblemsRequest, final AsyncHandler<ListUniqueProblemsRequest, ListUniqueProblemsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListUniqueProblemsResult>(){

            @Override
            public ListUniqueProblemsResult call() throws Exception {
                ListUniqueProblemsResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listUniqueProblems(listUniqueProblemsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listUniqueProblemsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListUploadsResult> listUploadsAsync(final ListUploadsRequest listUploadsRequest) {
        return this.executorService.submit(new Callable<ListUploadsResult>(){

            @Override
            public ListUploadsResult call() {
                return AWSDeviceFarmAsyncClient.this.listUploads(listUploadsRequest);
            }
        });
    }

    @Override
    public Future<ListUploadsResult> listUploadsAsync(final ListUploadsRequest listUploadsRequest, final AsyncHandler<ListUploadsRequest, ListUploadsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListUploadsResult>(){

            @Override
            public ListUploadsResult call() throws Exception {
                ListUploadsResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.listUploads(listUploadsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listUploadsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ScheduleRunResult> scheduleRunAsync(final ScheduleRunRequest scheduleRunRequest) {
        return this.executorService.submit(new Callable<ScheduleRunResult>(){

            @Override
            public ScheduleRunResult call() {
                return AWSDeviceFarmAsyncClient.this.scheduleRun(scheduleRunRequest);
            }
        });
    }

    @Override
    public Future<ScheduleRunResult> scheduleRunAsync(final ScheduleRunRequest scheduleRunRequest, final AsyncHandler<ScheduleRunRequest, ScheduleRunResult> asyncHandler) {
        return this.executorService.submit(new Callable<ScheduleRunResult>(){

            @Override
            public ScheduleRunResult call() throws Exception {
                ScheduleRunResult result;
                try {
                    result = AWSDeviceFarmAsyncClient.this.scheduleRun(scheduleRunRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)scheduleRunRequest, (Object)result);
                return result;
            }
        });
    }
}

