/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.devicefarm.model.Problem;
import com.amazonaws.services.devicefarm.model.transform.DeviceJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.ProblemDetailJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ProblemJsonMarshaller {
    private static ProblemJsonMarshaller instance;

    public void marshall(Problem problem, JSONWriter jsonWriter) {
        if (problem == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (problem.getRun() != null) {
                jsonWriter.key("run");
                ProblemDetailJsonMarshaller.getInstance().marshall(problem.getRun(), jsonWriter);
            }
            if (problem.getJob() != null) {
                jsonWriter.key("job");
                ProblemDetailJsonMarshaller.getInstance().marshall(problem.getJob(), jsonWriter);
            }
            if (problem.getSuite() != null) {
                jsonWriter.key("suite");
                ProblemDetailJsonMarshaller.getInstance().marshall(problem.getSuite(), jsonWriter);
            }
            if (problem.getTest() != null) {
                jsonWriter.key("test");
                ProblemDetailJsonMarshaller.getInstance().marshall(problem.getTest(), jsonWriter);
            }
            if (problem.getDevice() != null) {
                jsonWriter.key("device");
                DeviceJsonMarshaller.getInstance().marshall(problem.getDevice(), jsonWriter);
            }
            if (problem.getResult() != null) {
                jsonWriter.key("result").value((Object)problem.getResult());
            }
            if (problem.getMessage() != null) {
                jsonWriter.key("message").value((Object)problem.getMessage());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ProblemJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ProblemJsonMarshaller();
        }
        return instance;
    }
}

