/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.deadline.AWSDeadline;
import com.amazonaws.services.deadline.model.GetFleetRequest;
import com.amazonaws.services.deadline.model.GetJobRequest;
import com.amazonaws.services.deadline.model.GetLicenseEndpointRequest;
import com.amazonaws.services.deadline.model.GetQueueFleetAssociationRequest;
import com.amazonaws.services.deadline.model.GetQueueRequest;
import com.amazonaws.services.deadline.waiters.FleetActive;
import com.amazonaws.services.deadline.waiters.GetFleetFunction;
import com.amazonaws.services.deadline.waiters.GetJobFunction;
import com.amazonaws.services.deadline.waiters.GetLicenseEndpointFunction;
import com.amazonaws.services.deadline.waiters.GetQueueFleetAssociationFunction;
import com.amazonaws.services.deadline.waiters.GetQueueFunction;
import com.amazonaws.services.deadline.waiters.JobCreateComplete;
import com.amazonaws.services.deadline.waiters.LicenseEndpointDeleted;
import com.amazonaws.services.deadline.waiters.LicenseEndpointValid;
import com.amazonaws.services.deadline.waiters.QueueFleetAssociationStopped;
import com.amazonaws.services.deadline.waiters.QueueScheduling;
import com.amazonaws.services.deadline.waiters.QueueSchedulingBlocked;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AWSDeadlineWaiters {
    private final AWSDeadline client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AWSDeadlineWaiters");

    @SdkInternalApi
    public AWSDeadlineWaiters(AWSDeadline client) {
        this.client = client;
    }

    public Waiter<GetQueueRequest> queueScheduling() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetQueueFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new QueueScheduling.IsSCHEDULINGMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(70), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetJobRequest> jobCreateComplete() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetJobFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new JobCreateComplete.IsCREATE_COMPLETEMatcher(), new JobCreateComplete.IsUPDATE_IN_PROGRESSMatcher(), new JobCreateComplete.IsUPDATE_FAILEDMatcher(), new JobCreateComplete.IsUPDATE_SUCCEEDEDMatcher(), new JobCreateComplete.IsUPLOAD_FAILEDMatcher(), new JobCreateComplete.IsCREATE_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(1))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetQueueFleetAssociationRequest> queueFleetAssociationStopped() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetQueueFleetAssociationFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new QueueFleetAssociationStopped.IsSTOPPEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetFleetRequest> fleetActive() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetFleetFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new FleetActive.IsACTIVEMatcher(), new FleetActive.IsCREATE_FAILEDMatcher(), new FleetActive.IsUPDATE_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(180), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetLicenseEndpointRequest> licenseEndpointDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetLicenseEndpointFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new LicenseEndpointDeleted.IsResourceNotFoundExceptionMatcher(), new LicenseEndpointDeleted.IsNOT_READYMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(234), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetQueueRequest> queueSchedulingBlocked() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetQueueFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new QueueSchedulingBlocked.IsSCHEDULING_BLOCKEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(30), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetLicenseEndpointRequest> licenseEndpointValid() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetLicenseEndpointFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new LicenseEndpointValid.IsREADYMatcher(), new LicenseEndpointValid.IsNOT_READYMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(114), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

