/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.deadline.model.BudgetActionToAdd;
import com.amazonaws.services.deadline.model.BudgetActionToRemove;
import com.amazonaws.services.deadline.model.BudgetSchedule;
import com.amazonaws.services.deadline.model.BudgetStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateBudgetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<BudgetActionToAdd> actionsToAdd;
    private List<BudgetActionToRemove> actionsToRemove;
    private Float approximateDollarLimit;
    private String budgetId;
    private String clientToken;
    private String description;
    private String displayName;
    private String farmId;
    private BudgetSchedule schedule;
    private String status;

    public List<BudgetActionToAdd> getActionsToAdd() {
        return this.actionsToAdd;
    }

    public void setActionsToAdd(Collection<BudgetActionToAdd> actionsToAdd) {
        if (actionsToAdd == null) {
            this.actionsToAdd = null;
            return;
        }
        this.actionsToAdd = new ArrayList<BudgetActionToAdd>(actionsToAdd);
    }

    public UpdateBudgetRequest withActionsToAdd(BudgetActionToAdd ... actionsToAdd) {
        if (this.actionsToAdd == null) {
            this.setActionsToAdd(new ArrayList<BudgetActionToAdd>(actionsToAdd.length));
        }
        for (BudgetActionToAdd ele : actionsToAdd) {
            this.actionsToAdd.add(ele);
        }
        return this;
    }

    public UpdateBudgetRequest withActionsToAdd(Collection<BudgetActionToAdd> actionsToAdd) {
        this.setActionsToAdd(actionsToAdd);
        return this;
    }

    public List<BudgetActionToRemove> getActionsToRemove() {
        return this.actionsToRemove;
    }

    public void setActionsToRemove(Collection<BudgetActionToRemove> actionsToRemove) {
        if (actionsToRemove == null) {
            this.actionsToRemove = null;
            return;
        }
        this.actionsToRemove = new ArrayList<BudgetActionToRemove>(actionsToRemove);
    }

    public UpdateBudgetRequest withActionsToRemove(BudgetActionToRemove ... actionsToRemove) {
        if (this.actionsToRemove == null) {
            this.setActionsToRemove(new ArrayList<BudgetActionToRemove>(actionsToRemove.length));
        }
        for (BudgetActionToRemove ele : actionsToRemove) {
            this.actionsToRemove.add(ele);
        }
        return this;
    }

    public UpdateBudgetRequest withActionsToRemove(Collection<BudgetActionToRemove> actionsToRemove) {
        this.setActionsToRemove(actionsToRemove);
        return this;
    }

    public void setApproximateDollarLimit(Float approximateDollarLimit) {
        this.approximateDollarLimit = approximateDollarLimit;
    }

    public Float getApproximateDollarLimit() {
        return this.approximateDollarLimit;
    }

    public UpdateBudgetRequest withApproximateDollarLimit(Float approximateDollarLimit) {
        this.setApproximateDollarLimit(approximateDollarLimit);
        return this;
    }

    public void setBudgetId(String budgetId) {
        this.budgetId = budgetId;
    }

    public String getBudgetId() {
        return this.budgetId;
    }

    public UpdateBudgetRequest withBudgetId(String budgetId) {
        this.setBudgetId(budgetId);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public UpdateBudgetRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateBudgetRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public UpdateBudgetRequest withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setFarmId(String farmId) {
        this.farmId = farmId;
    }

    public String getFarmId() {
        return this.farmId;
    }

    public UpdateBudgetRequest withFarmId(String farmId) {
        this.setFarmId(farmId);
        return this;
    }

    public void setSchedule(BudgetSchedule schedule) {
        this.schedule = schedule;
    }

    public BudgetSchedule getSchedule() {
        return this.schedule;
    }

    public UpdateBudgetRequest withSchedule(BudgetSchedule schedule) {
        this.setSchedule(schedule);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public UpdateBudgetRequest withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public UpdateBudgetRequest withStatus(BudgetStatus status) {
        this.status = status.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActionsToAdd() != null) {
            sb.append("ActionsToAdd: ").append(this.getActionsToAdd()).append(",");
        }
        if (this.getActionsToRemove() != null) {
            sb.append("ActionsToRemove: ").append(this.getActionsToRemove()).append(",");
        }
        if (this.getApproximateDollarLimit() != null) {
            sb.append("ApproximateDollarLimit: ").append(this.getApproximateDollarLimit()).append(",");
        }
        if (this.getBudgetId() != null) {
            sb.append("BudgetId: ").append(this.getBudgetId()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getFarmId() != null) {
            sb.append("FarmId: ").append(this.getFarmId()).append(",");
        }
        if (this.getSchedule() != null) {
            sb.append("Schedule: ").append(this.getSchedule()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBudgetRequest)) {
            return false;
        }
        UpdateBudgetRequest other = (UpdateBudgetRequest)obj;
        if (other.getActionsToAdd() == null ^ this.getActionsToAdd() == null) {
            return false;
        }
        if (other.getActionsToAdd() != null && !other.getActionsToAdd().equals(this.getActionsToAdd())) {
            return false;
        }
        if (other.getActionsToRemove() == null ^ this.getActionsToRemove() == null) {
            return false;
        }
        if (other.getActionsToRemove() != null && !other.getActionsToRemove().equals(this.getActionsToRemove())) {
            return false;
        }
        if (other.getApproximateDollarLimit() == null ^ this.getApproximateDollarLimit() == null) {
            return false;
        }
        if (other.getApproximateDollarLimit() != null && !other.getApproximateDollarLimit().equals(this.getApproximateDollarLimit())) {
            return false;
        }
        if (other.getBudgetId() == null ^ this.getBudgetId() == null) {
            return false;
        }
        if (other.getBudgetId() != null && !other.getBudgetId().equals(this.getBudgetId())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getFarmId() == null ^ this.getFarmId() == null) {
            return false;
        }
        if (other.getFarmId() != null && !other.getFarmId().equals(this.getFarmId())) {
            return false;
        }
        if (other.getSchedule() == null ^ this.getSchedule() == null) {
            return false;
        }
        if (other.getSchedule() != null && !other.getSchedule().equals(this.getSchedule())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        return other.getStatus() == null || other.getStatus().equals(this.getStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActionsToAdd() == null ? 0 : this.getActionsToAdd().hashCode());
        hashCode = 31 * hashCode + (this.getActionsToRemove() == null ? 0 : this.getActionsToRemove().hashCode());
        hashCode = 31 * hashCode + (this.getApproximateDollarLimit() == null ? 0 : this.getApproximateDollarLimit().hashCode());
        hashCode = 31 * hashCode + (this.getBudgetId() == null ? 0 : this.getBudgetId().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getFarmId() == null ? 0 : this.getFarmId().hashCode());
        hashCode = 31 * hashCode + (this.getSchedule() == null ? 0 : this.getSchedule().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        return hashCode;
    }

    public UpdateBudgetRequest clone() {
        return (UpdateBudgetRequest)super.clone();
    }
}

