/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.deadline.model.AssignedSession;
import com.amazonaws.services.deadline.model.DesiredWorkerStatus;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateWorkerScheduleResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private Map<String, AssignedSession> assignedSessions;
    private Map<String, List<String>> cancelSessionActions;
    private String desiredWorkerStatus;
    private Integer updateIntervalSeconds;

    public Map<String, AssignedSession> getAssignedSessions() {
        return this.assignedSessions;
    }

    public void setAssignedSessions(Map<String, AssignedSession> assignedSessions) {
        this.assignedSessions = assignedSessions;
    }

    public UpdateWorkerScheduleResult withAssignedSessions(Map<String, AssignedSession> assignedSessions) {
        this.setAssignedSessions(assignedSessions);
        return this;
    }

    public UpdateWorkerScheduleResult addAssignedSessionsEntry(String key, AssignedSession value) {
        if (null == this.assignedSessions) {
            this.assignedSessions = new HashMap<String, AssignedSession>();
        }
        if (this.assignedSessions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.assignedSessions.put(key, value);
        return this;
    }

    public UpdateWorkerScheduleResult clearAssignedSessionsEntries() {
        this.assignedSessions = null;
        return this;
    }

    public Map<String, List<String>> getCancelSessionActions() {
        return this.cancelSessionActions;
    }

    public void setCancelSessionActions(Map<String, List<String>> cancelSessionActions) {
        this.cancelSessionActions = cancelSessionActions;
    }

    public UpdateWorkerScheduleResult withCancelSessionActions(Map<String, List<String>> cancelSessionActions) {
        this.setCancelSessionActions(cancelSessionActions);
        return this;
    }

    public UpdateWorkerScheduleResult addCancelSessionActionsEntry(String key, List<String> value) {
        if (null == this.cancelSessionActions) {
            this.cancelSessionActions = new HashMap<String, List<String>>();
        }
        if (this.cancelSessionActions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.cancelSessionActions.put(key, value);
        return this;
    }

    public UpdateWorkerScheduleResult clearCancelSessionActionsEntries() {
        this.cancelSessionActions = null;
        return this;
    }

    public void setDesiredWorkerStatus(String desiredWorkerStatus) {
        this.desiredWorkerStatus = desiredWorkerStatus;
    }

    public String getDesiredWorkerStatus() {
        return this.desiredWorkerStatus;
    }

    public UpdateWorkerScheduleResult withDesiredWorkerStatus(String desiredWorkerStatus) {
        this.setDesiredWorkerStatus(desiredWorkerStatus);
        return this;
    }

    public UpdateWorkerScheduleResult withDesiredWorkerStatus(DesiredWorkerStatus desiredWorkerStatus) {
        this.desiredWorkerStatus = desiredWorkerStatus.toString();
        return this;
    }

    public void setUpdateIntervalSeconds(Integer updateIntervalSeconds) {
        this.updateIntervalSeconds = updateIntervalSeconds;
    }

    public Integer getUpdateIntervalSeconds() {
        return this.updateIntervalSeconds;
    }

    public UpdateWorkerScheduleResult withUpdateIntervalSeconds(Integer updateIntervalSeconds) {
        this.setUpdateIntervalSeconds(updateIntervalSeconds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssignedSessions() != null) {
            sb.append("AssignedSessions: ").append(this.getAssignedSessions()).append(",");
        }
        if (this.getCancelSessionActions() != null) {
            sb.append("CancelSessionActions: ").append(this.getCancelSessionActions()).append(",");
        }
        if (this.getDesiredWorkerStatus() != null) {
            sb.append("DesiredWorkerStatus: ").append(this.getDesiredWorkerStatus()).append(",");
        }
        if (this.getUpdateIntervalSeconds() != null) {
            sb.append("UpdateIntervalSeconds: ").append(this.getUpdateIntervalSeconds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkerScheduleResult)) {
            return false;
        }
        UpdateWorkerScheduleResult other = (UpdateWorkerScheduleResult)obj;
        if (other.getAssignedSessions() == null ^ this.getAssignedSessions() == null) {
            return false;
        }
        if (other.getAssignedSessions() != null && !other.getAssignedSessions().equals(this.getAssignedSessions())) {
            return false;
        }
        if (other.getCancelSessionActions() == null ^ this.getCancelSessionActions() == null) {
            return false;
        }
        if (other.getCancelSessionActions() != null && !other.getCancelSessionActions().equals(this.getCancelSessionActions())) {
            return false;
        }
        if (other.getDesiredWorkerStatus() == null ^ this.getDesiredWorkerStatus() == null) {
            return false;
        }
        if (other.getDesiredWorkerStatus() != null && !other.getDesiredWorkerStatus().equals(this.getDesiredWorkerStatus())) {
            return false;
        }
        if (other.getUpdateIntervalSeconds() == null ^ this.getUpdateIntervalSeconds() == null) {
            return false;
        }
        return other.getUpdateIntervalSeconds() == null || other.getUpdateIntervalSeconds().equals(this.getUpdateIntervalSeconds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssignedSessions() == null ? 0 : this.getAssignedSessions().hashCode());
        hashCode = 31 * hashCode + (this.getCancelSessionActions() == null ? 0 : this.getCancelSessionActions().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredWorkerStatus() == null ? 0 : this.getDesiredWorkerStatus().hashCode());
        hashCode = 31 * hashCode + (this.getUpdateIntervalSeconds() == null ? 0 : this.getUpdateIntervalSeconds().hashCode());
        return hashCode;
    }

    public UpdateWorkerScheduleResult clone() {
        try {
            return (UpdateWorkerScheduleResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

