/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.deadline.model.TaskSearchSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchTasksResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private Integer nextItemOffset;
    private List<TaskSearchSummary> tasks;
    private Integer totalResults;

    public void setNextItemOffset(Integer nextItemOffset) {
        this.nextItemOffset = nextItemOffset;
    }

    public Integer getNextItemOffset() {
        return this.nextItemOffset;
    }

    public SearchTasksResult withNextItemOffset(Integer nextItemOffset) {
        this.setNextItemOffset(nextItemOffset);
        return this;
    }

    public List<TaskSearchSummary> getTasks() {
        return this.tasks;
    }

    public void setTasks(Collection<TaskSearchSummary> tasks) {
        if (tasks == null) {
            this.tasks = null;
            return;
        }
        this.tasks = new ArrayList<TaskSearchSummary>(tasks);
    }

    public SearchTasksResult withTasks(TaskSearchSummary ... tasks) {
        if (this.tasks == null) {
            this.setTasks(new ArrayList<TaskSearchSummary>(tasks.length));
        }
        for (TaskSearchSummary ele : tasks) {
            this.tasks.add(ele);
        }
        return this;
    }

    public SearchTasksResult withTasks(Collection<TaskSearchSummary> tasks) {
        this.setTasks(tasks);
        return this;
    }

    public void setTotalResults(Integer totalResults) {
        this.totalResults = totalResults;
    }

    public Integer getTotalResults() {
        return this.totalResults;
    }

    public SearchTasksResult withTotalResults(Integer totalResults) {
        this.setTotalResults(totalResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextItemOffset() != null) {
            sb.append("NextItemOffset: ").append(this.getNextItemOffset()).append(",");
        }
        if (this.getTasks() != null) {
            sb.append("Tasks: ").append(this.getTasks()).append(",");
        }
        if (this.getTotalResults() != null) {
            sb.append("TotalResults: ").append(this.getTotalResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTasksResult)) {
            return false;
        }
        SearchTasksResult other = (SearchTasksResult)obj;
        if (other.getNextItemOffset() == null ^ this.getNextItemOffset() == null) {
            return false;
        }
        if (other.getNextItemOffset() != null && !other.getNextItemOffset().equals(this.getNextItemOffset())) {
            return false;
        }
        if (other.getTasks() == null ^ this.getTasks() == null) {
            return false;
        }
        if (other.getTasks() != null && !other.getTasks().equals(this.getTasks())) {
            return false;
        }
        if (other.getTotalResults() == null ^ this.getTotalResults() == null) {
            return false;
        }
        return other.getTotalResults() == null || other.getTotalResults().equals(this.getTotalResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextItemOffset() == null ? 0 : this.getNextItemOffset().hashCode());
        hashCode = 31 * hashCode + (this.getTasks() == null ? 0 : this.getTasks().hashCode());
        hashCode = 31 * hashCode + (this.getTotalResults() == null ? 0 : this.getTotalResults().hashCode());
        return hashCode;
    }

    public SearchTasksResult clone() {
        try {
            return (SearchTasksResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

