/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datazone.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.datazone.model.NotificationOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListNotificationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<NotificationOutput> notifications;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListNotificationsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<NotificationOutput> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(Collection<NotificationOutput> notifications) {
        if (notifications == null) {
            this.notifications = null;
            return;
        }
        this.notifications = new ArrayList<NotificationOutput>(notifications);
    }

    public ListNotificationsResult withNotifications(NotificationOutput ... notifications) {
        if (this.notifications == null) {
            this.setNotifications(new ArrayList<NotificationOutput>(notifications.length));
        }
        for (NotificationOutput ele : notifications) {
            this.notifications.add(ele);
        }
        return this;
    }

    public ListNotificationsResult withNotifications(Collection<NotificationOutput> notifications) {
        this.setNotifications(notifications);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getNotifications() != null) {
            sb.append("Notifications: ").append(this.getNotifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationsResult)) {
            return false;
        }
        ListNotificationsResult other = (ListNotificationsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getNotifications() == null ^ this.getNotifications() == null) {
            return false;
        }
        return other.getNotifications() == null || other.getNotifications().equals(this.getNotifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getNotifications() == null ? 0 : this.getNotifications().hashCode());
        return hashCode;
    }

    public ListNotificationsResult clone() {
        try {
            return (ListNotificationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

