/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.datasync.model.S3ManifestConfig;

@SdkInternalApi
public class S3ManifestConfigMarshaller {
    private static final MarshallingInfo<String> MANIFESTOBJECTPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ManifestObjectPath").build();
    private static final MarshallingInfo<String> BUCKETACCESSROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketAccessRoleArn").build();
    private static final MarshallingInfo<String> S3BUCKETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BucketArn").build();
    private static final MarshallingInfo<String> MANIFESTOBJECTVERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ManifestObjectVersionId").build();
    private static final S3ManifestConfigMarshaller instance = new S3ManifestConfigMarshaller();

    public static S3ManifestConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3ManifestConfig s3ManifestConfig, ProtocolMarshaller protocolMarshaller) {
        if (s3ManifestConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3ManifestConfig.getManifestObjectPath(), MANIFESTOBJECTPATH_BINDING);
            protocolMarshaller.marshall((Object)s3ManifestConfig.getBucketAccessRoleArn(), BUCKETACCESSROLEARN_BINDING);
            protocolMarshaller.marshall((Object)s3ManifestConfig.getS3BucketArn(), S3BUCKETARN_BINDING);
            protocolMarshaller.marshall((Object)s3ManifestConfig.getManifestObjectVersionId(), MANIFESTOBJECTVERSIONID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

