/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.datasync.model.transform.PrivateLinkConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PrivateLinkConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String privateLinkEndpoint;
    private List<String> subnetArns;
    private List<String> securityGroupArns;

    public void setPrivateLinkEndpoint(String privateLinkEndpoint) {
        this.privateLinkEndpoint = privateLinkEndpoint;
    }

    public String getPrivateLinkEndpoint() {
        return this.privateLinkEndpoint;
    }

    public PrivateLinkConfig withPrivateLinkEndpoint(String privateLinkEndpoint) {
        this.setPrivateLinkEndpoint(privateLinkEndpoint);
        return this;
    }

    public List<String> getSubnetArns() {
        return this.subnetArns;
    }

    public void setSubnetArns(Collection<String> subnetArns) {
        if (subnetArns == null) {
            this.subnetArns = null;
            return;
        }
        this.subnetArns = new ArrayList<String>(subnetArns);
    }

    public PrivateLinkConfig withSubnetArns(String ... subnetArns) {
        if (this.subnetArns == null) {
            this.setSubnetArns(new ArrayList<String>(subnetArns.length));
        }
        for (String ele : subnetArns) {
            this.subnetArns.add(ele);
        }
        return this;
    }

    public PrivateLinkConfig withSubnetArns(Collection<String> subnetArns) {
        this.setSubnetArns(subnetArns);
        return this;
    }

    public List<String> getSecurityGroupArns() {
        return this.securityGroupArns;
    }

    public void setSecurityGroupArns(Collection<String> securityGroupArns) {
        if (securityGroupArns == null) {
            this.securityGroupArns = null;
            return;
        }
        this.securityGroupArns = new ArrayList<String>(securityGroupArns);
    }

    public PrivateLinkConfig withSecurityGroupArns(String ... securityGroupArns) {
        if (this.securityGroupArns == null) {
            this.setSecurityGroupArns(new ArrayList<String>(securityGroupArns.length));
        }
        for (String ele : securityGroupArns) {
            this.securityGroupArns.add(ele);
        }
        return this;
    }

    public PrivateLinkConfig withSecurityGroupArns(Collection<String> securityGroupArns) {
        this.setSecurityGroupArns(securityGroupArns);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPrivateLinkEndpoint() != null) {
            sb.append("PrivateLinkEndpoint: ").append(this.getPrivateLinkEndpoint()).append(",");
        }
        if (this.getSubnetArns() != null) {
            sb.append("SubnetArns: ").append(this.getSubnetArns()).append(",");
        }
        if (this.getSecurityGroupArns() != null) {
            sb.append("SecurityGroupArns: ").append(this.getSecurityGroupArns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateLinkConfig)) {
            return false;
        }
        PrivateLinkConfig other = (PrivateLinkConfig)obj;
        if (other.getPrivateLinkEndpoint() == null ^ this.getPrivateLinkEndpoint() == null) {
            return false;
        }
        if (other.getPrivateLinkEndpoint() != null && !other.getPrivateLinkEndpoint().equals(this.getPrivateLinkEndpoint())) {
            return false;
        }
        if (other.getSubnetArns() == null ^ this.getSubnetArns() == null) {
            return false;
        }
        if (other.getSubnetArns() != null && !other.getSubnetArns().equals(this.getSubnetArns())) {
            return false;
        }
        if (other.getSecurityGroupArns() == null ^ this.getSecurityGroupArns() == null) {
            return false;
        }
        return other.getSecurityGroupArns() == null || other.getSecurityGroupArns().equals(this.getSecurityGroupArns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPrivateLinkEndpoint() == null ? 0 : this.getPrivateLinkEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetArns() == null ? 0 : this.getSubnetArns().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupArns() == null ? 0 : this.getSecurityGroupArns().hashCode());
        return hashCode;
    }

    public PrivateLinkConfig clone() {
        try {
            return (PrivateLinkConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PrivateLinkConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

