/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.datapipeline.model.PollForTaskRequest;
import com.amazonaws.services.datapipeline.model.transform.InstanceIdentityJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PollForTaskRequestMarshaller
implements Marshaller<Request<PollForTaskRequest>, PollForTaskRequest> {
    public Request<PollForTaskRequest> marshall(PollForTaskRequest pollForTaskRequest) {
        if (pollForTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)pollForTaskRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.PollForTask");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (pollForTaskRequest.getWorkerGroup() != null) {
                jsonGenerator.writeFieldName("workerGroup").writeValue(pollForTaskRequest.getWorkerGroup());
            }
            if (pollForTaskRequest.getHostname() != null) {
                jsonGenerator.writeFieldName("hostname").writeValue(pollForTaskRequest.getHostname());
            }
            if (pollForTaskRequest.getInstanceIdentity() != null) {
                jsonGenerator.writeFieldName("instanceIdentity");
                InstanceIdentityJsonMarshaller.getInstance().marshall(pollForTaskRequest.getInstanceIdentity(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

