/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.customerprofiles.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetectProfileObjectTypeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> objects;
    private String domainName;

    public List<String> getObjects() {
        return this.objects;
    }

    public void setObjects(Collection<String> objects) {
        if (objects == null) {
            this.objects = null;
            return;
        }
        this.objects = new ArrayList<String>(objects);
    }

    public DetectProfileObjectTypeRequest withObjects(String ... objects) {
        if (this.objects == null) {
            this.setObjects(new ArrayList<String>(objects.length));
        }
        for (String ele : objects) {
            this.objects.add(ele);
        }
        return this;
    }

    public DetectProfileObjectTypeRequest withObjects(Collection<String> objects) {
        this.setObjects(objects);
        return this;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public DetectProfileObjectTypeRequest withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getObjects() != null) {
            sb.append("Objects: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getDomainName() != null) {
            sb.append("DomainName: ").append(this.getDomainName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectProfileObjectTypeRequest)) {
            return false;
        }
        DetectProfileObjectTypeRequest other = (DetectProfileObjectTypeRequest)obj;
        if (other.getObjects() == null ^ this.getObjects() == null) {
            return false;
        }
        if (other.getObjects() != null && !other.getObjects().equals(this.getObjects())) {
            return false;
        }
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        return other.getDomainName() == null || other.getDomainName().equals(this.getDomainName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getObjects() == null ? 0 : this.getObjects().hashCode());
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        return hashCode;
    }

    public DetectProfileObjectTypeRequest clone() {
        return (DetectProfileObjectTypeRequest)super.clone();
    }
}

