/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.customerprofiles.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.customerprofiles.model.SourceFlowConfig;
import com.amazonaws.services.customerprofiles.model.Task;
import com.amazonaws.services.customerprofiles.model.TriggerConfig;
import com.amazonaws.services.customerprofiles.model.transform.FlowDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FlowDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private String description;
    private String flowName;
    private String kmsArn;
    private SourceFlowConfig sourceFlowConfig;
    private List<Task> tasks;
    private TriggerConfig triggerConfig;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public FlowDefinition withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public FlowDefinition withFlowName(String flowName) {
        this.setFlowName(flowName);
        return this;
    }

    public void setKmsArn(String kmsArn) {
        this.kmsArn = kmsArn;
    }

    public String getKmsArn() {
        return this.kmsArn;
    }

    public FlowDefinition withKmsArn(String kmsArn) {
        this.setKmsArn(kmsArn);
        return this;
    }

    public void setSourceFlowConfig(SourceFlowConfig sourceFlowConfig) {
        this.sourceFlowConfig = sourceFlowConfig;
    }

    public SourceFlowConfig getSourceFlowConfig() {
        return this.sourceFlowConfig;
    }

    public FlowDefinition withSourceFlowConfig(SourceFlowConfig sourceFlowConfig) {
        this.setSourceFlowConfig(sourceFlowConfig);
        return this;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(Collection<Task> tasks) {
        if (tasks == null) {
            this.tasks = null;
            return;
        }
        this.tasks = new ArrayList<Task>(tasks);
    }

    public FlowDefinition withTasks(Task ... tasks) {
        if (this.tasks == null) {
            this.setTasks(new ArrayList<Task>(tasks.length));
        }
        for (Task ele : tasks) {
            this.tasks.add(ele);
        }
        return this;
    }

    public FlowDefinition withTasks(Collection<Task> tasks) {
        this.setTasks(tasks);
        return this;
    }

    public void setTriggerConfig(TriggerConfig triggerConfig) {
        this.triggerConfig = triggerConfig;
    }

    public TriggerConfig getTriggerConfig() {
        return this.triggerConfig;
    }

    public FlowDefinition withTriggerConfig(TriggerConfig triggerConfig) {
        this.setTriggerConfig(triggerConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getFlowName() != null) {
            sb.append("FlowName: ").append(this.getFlowName()).append(",");
        }
        if (this.getKmsArn() != null) {
            sb.append("KmsArn: ").append(this.getKmsArn()).append(",");
        }
        if (this.getSourceFlowConfig() != null) {
            sb.append("SourceFlowConfig: ").append(this.getSourceFlowConfig()).append(",");
        }
        if (this.getTasks() != null) {
            sb.append("Tasks: ").append(this.getTasks()).append(",");
        }
        if (this.getTriggerConfig() != null) {
            sb.append("TriggerConfig: ").append(this.getTriggerConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowDefinition)) {
            return false;
        }
        FlowDefinition other = (FlowDefinition)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getFlowName() == null ^ this.getFlowName() == null) {
            return false;
        }
        if (other.getFlowName() != null && !other.getFlowName().equals(this.getFlowName())) {
            return false;
        }
        if (other.getKmsArn() == null ^ this.getKmsArn() == null) {
            return false;
        }
        if (other.getKmsArn() != null && !other.getKmsArn().equals(this.getKmsArn())) {
            return false;
        }
        if (other.getSourceFlowConfig() == null ^ this.getSourceFlowConfig() == null) {
            return false;
        }
        if (other.getSourceFlowConfig() != null && !other.getSourceFlowConfig().equals(this.getSourceFlowConfig())) {
            return false;
        }
        if (other.getTasks() == null ^ this.getTasks() == null) {
            return false;
        }
        if (other.getTasks() != null && !other.getTasks().equals(this.getTasks())) {
            return false;
        }
        if (other.getTriggerConfig() == null ^ this.getTriggerConfig() == null) {
            return false;
        }
        return other.getTriggerConfig() == null || other.getTriggerConfig().equals(this.getTriggerConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getFlowName() == null ? 0 : this.getFlowName().hashCode());
        hashCode = 31 * hashCode + (this.getKmsArn() == null ? 0 : this.getKmsArn().hashCode());
        hashCode = 31 * hashCode + (this.getSourceFlowConfig() == null ? 0 : this.getSourceFlowConfig().hashCode());
        hashCode = 31 * hashCode + (this.getTasks() == null ? 0 : this.getTasks().hashCode());
        hashCode = 31 * hashCode + (this.getTriggerConfig() == null ? 0 : this.getTriggerConfig().hashCode());
        return hashCode;
    }

    public FlowDefinition clone() {
        try {
            return (FlowDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FlowDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

