/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.customerprofiles.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.customerprofiles.model.ConnectorOperator;
import com.amazonaws.services.customerprofiles.model.TaskType;
import com.amazonaws.services.customerprofiles.model.transform.TaskMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Task
implements Serializable,
Cloneable,
StructuredPojo {
    private ConnectorOperator connectorOperator;
    private String destinationField;
    private List<String> sourceFields;
    private Map<String, String> taskProperties;
    private String taskType;

    public void setConnectorOperator(ConnectorOperator connectorOperator) {
        this.connectorOperator = connectorOperator;
    }

    public ConnectorOperator getConnectorOperator() {
        return this.connectorOperator;
    }

    public Task withConnectorOperator(ConnectorOperator connectorOperator) {
        this.setConnectorOperator(connectorOperator);
        return this;
    }

    public void setDestinationField(String destinationField) {
        this.destinationField = destinationField;
    }

    public String getDestinationField() {
        return this.destinationField;
    }

    public Task withDestinationField(String destinationField) {
        this.setDestinationField(destinationField);
        return this;
    }

    public List<String> getSourceFields() {
        return this.sourceFields;
    }

    public void setSourceFields(Collection<String> sourceFields) {
        if (sourceFields == null) {
            this.sourceFields = null;
            return;
        }
        this.sourceFields = new ArrayList<String>(sourceFields);
    }

    public Task withSourceFields(String ... sourceFields) {
        if (this.sourceFields == null) {
            this.setSourceFields(new ArrayList<String>(sourceFields.length));
        }
        for (String ele : sourceFields) {
            this.sourceFields.add(ele);
        }
        return this;
    }

    public Task withSourceFields(Collection<String> sourceFields) {
        this.setSourceFields(sourceFields);
        return this;
    }

    public Map<String, String> getTaskProperties() {
        return this.taskProperties;
    }

    public void setTaskProperties(Map<String, String> taskProperties) {
        this.taskProperties = taskProperties;
    }

    public Task withTaskProperties(Map<String, String> taskProperties) {
        this.setTaskProperties(taskProperties);
        return this;
    }

    public Task addTaskPropertiesEntry(String key, String value) {
        if (null == this.taskProperties) {
            this.taskProperties = new HashMap<String, String>();
        }
        if (this.taskProperties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.taskProperties.put(key, value);
        return this;
    }

    public Task clearTaskPropertiesEntries() {
        this.taskProperties = null;
        return this;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public Task withTaskType(String taskType) {
        this.setTaskType(taskType);
        return this;
    }

    public Task withTaskType(TaskType taskType) {
        this.taskType = taskType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConnectorOperator() != null) {
            sb.append("ConnectorOperator: ").append(this.getConnectorOperator()).append(",");
        }
        if (this.getDestinationField() != null) {
            sb.append("DestinationField: ").append(this.getDestinationField()).append(",");
        }
        if (this.getSourceFields() != null) {
            sb.append("SourceFields: ").append(this.getSourceFields()).append(",");
        }
        if (this.getTaskProperties() != null) {
            sb.append("TaskProperties: ").append(this.getTaskProperties()).append(",");
        }
        if (this.getTaskType() != null) {
            sb.append("TaskType: ").append(this.getTaskType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Task)) {
            return false;
        }
        Task other = (Task)obj;
        if (other.getConnectorOperator() == null ^ this.getConnectorOperator() == null) {
            return false;
        }
        if (other.getConnectorOperator() != null && !other.getConnectorOperator().equals(this.getConnectorOperator())) {
            return false;
        }
        if (other.getDestinationField() == null ^ this.getDestinationField() == null) {
            return false;
        }
        if (other.getDestinationField() != null && !other.getDestinationField().equals(this.getDestinationField())) {
            return false;
        }
        if (other.getSourceFields() == null ^ this.getSourceFields() == null) {
            return false;
        }
        if (other.getSourceFields() != null && !other.getSourceFields().equals(this.getSourceFields())) {
            return false;
        }
        if (other.getTaskProperties() == null ^ this.getTaskProperties() == null) {
            return false;
        }
        if (other.getTaskProperties() != null && !other.getTaskProperties().equals(this.getTaskProperties())) {
            return false;
        }
        if (other.getTaskType() == null ^ this.getTaskType() == null) {
            return false;
        }
        return other.getTaskType() == null || other.getTaskType().equals(this.getTaskType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConnectorOperator() == null ? 0 : this.getConnectorOperator().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationField() == null ? 0 : this.getDestinationField().hashCode());
        hashCode = 31 * hashCode + (this.getSourceFields() == null ? 0 : this.getSourceFields().hashCode());
        hashCode = 31 * hashCode + (this.getTaskProperties() == null ? 0 : this.getTaskProperties().hashCode());
        hashCode = 31 * hashCode + (this.getTaskType() == null ? 0 : this.getTaskType().hashCode());
        return hashCode;
    }

    public Task clone() {
        try {
            return (Task)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TaskMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

