/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.costexplorer.model.CostCategorySplitChargeMethod;
import com.amazonaws.services.costexplorer.model.CostCategorySplitChargeRuleParameter;
import com.amazonaws.services.costexplorer.model.transform.CostCategorySplitChargeRuleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CostCategorySplitChargeRule
implements Serializable,
Cloneable,
StructuredPojo {
    private String source;
    private List<String> targets;
    private String method;
    private List<CostCategorySplitChargeRuleParameter> parameters;

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public CostCategorySplitChargeRule withSource(String source) {
        this.setSource(source);
        return this;
    }

    public List<String> getTargets() {
        return this.targets;
    }

    public void setTargets(Collection<String> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new ArrayList<String>(targets);
    }

    public CostCategorySplitChargeRule withTargets(String ... targets) {
        if (this.targets == null) {
            this.setTargets(new ArrayList<String>(targets.length));
        }
        for (String ele : targets) {
            this.targets.add(ele);
        }
        return this;
    }

    public CostCategorySplitChargeRule withTargets(Collection<String> targets) {
        this.setTargets(targets);
        return this;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public CostCategorySplitChargeRule withMethod(String method) {
        this.setMethod(method);
        return this;
    }

    public CostCategorySplitChargeRule withMethod(CostCategorySplitChargeMethod method) {
        this.method = method.toString();
        return this;
    }

    public List<CostCategorySplitChargeRuleParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Collection<CostCategorySplitChargeRuleParameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new ArrayList<CostCategorySplitChargeRuleParameter>(parameters);
    }

    public CostCategorySplitChargeRule withParameters(CostCategorySplitChargeRuleParameter ... parameters) {
        if (this.parameters == null) {
            this.setParameters(new ArrayList<CostCategorySplitChargeRuleParameter>(parameters.length));
        }
        for (CostCategorySplitChargeRuleParameter ele : parameters) {
            this.parameters.add(ele);
        }
        return this;
    }

    public CostCategorySplitChargeRule withParameters(Collection<CostCategorySplitChargeRuleParameter> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getMethod() != null) {
            sb.append("Method: ").append(this.getMethod()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostCategorySplitChargeRule)) {
            return false;
        }
        CostCategorySplitChargeRule other = (CostCategorySplitChargeRule)obj;
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getMethod() == null ^ this.getMethod() == null) {
            return false;
        }
        if (other.getMethod() != null && !other.getMethod().equals(this.getMethod())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getMethod() == null ? 0 : this.getMethod().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public CostCategorySplitChargeRule clone() {
        try {
            return (CostCategorySplitChargeRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CostCategorySplitChargeRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

