/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costandusagereport.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.costandusagereport.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TagResourceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String reportName;
    private List<Tag> tags;

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public String getReportName() {
        return this.reportName;
    }

    public TagResourceRequest withReportName(String reportName) {
        this.setReportName(reportName);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public TagResourceRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public TagResourceRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReportName() != null) {
            sb.append("ReportName: ").append(this.getReportName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagResourceRequest)) {
            return false;
        }
        TagResourceRequest other = (TagResourceRequest)obj;
        if (other.getReportName() == null ^ this.getReportName() == null) {
            return false;
        }
        if (other.getReportName() != null && !other.getReportName().equals(this.getReportName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReportName() == null ? 0 : this.getReportName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public TagResourceRequest clone() {
        return (TagResourceRequest)super.clone();
    }
}

