/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costandusagereport.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.costandusagereport.model.PutReportDefinitionRequest;
import com.amazonaws.services.costandusagereport.model.transform.ReportDefinitionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PutReportDefinitionRequestMarshaller
implements Marshaller<Request<PutReportDefinitionRequest>, PutReportDefinitionRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public PutReportDefinitionRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutReportDefinitionRequest> marshall(PutReportDefinitionRequest putReportDefinitionRequest) {
        if (putReportDefinitionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putReportDefinitionRequest, "AWSCostAndUsageReport");
        request.addHeader("X-Amz-Target", "AWSOrigamiServiceGatewayService.PutReportDefinition");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putReportDefinitionRequest.getReportDefinition() != null) {
                jsonGenerator.writeFieldName("ReportDefinition");
                ReportDefinitionJsonMarshaller.getInstance().marshall(putReportDefinitionRequest.getReportDefinition(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

