/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectcontactlens.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connectcontactlens.model.CategoryDetails;
import com.amazonaws.services.connectcontactlens.model.transform.CategoriesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Categories
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> matchedCategories;
    private Map<String, CategoryDetails> matchedDetails;

    public List<String> getMatchedCategories() {
        return this.matchedCategories;
    }

    public void setMatchedCategories(Collection<String> matchedCategories) {
        if (matchedCategories == null) {
            this.matchedCategories = null;
            return;
        }
        this.matchedCategories = new ArrayList<String>(matchedCategories);
    }

    public Categories withMatchedCategories(String ... matchedCategories) {
        if (this.matchedCategories == null) {
            this.setMatchedCategories(new ArrayList<String>(matchedCategories.length));
        }
        for (String ele : matchedCategories) {
            this.matchedCategories.add(ele);
        }
        return this;
    }

    public Categories withMatchedCategories(Collection<String> matchedCategories) {
        this.setMatchedCategories(matchedCategories);
        return this;
    }

    public Map<String, CategoryDetails> getMatchedDetails() {
        return this.matchedDetails;
    }

    public void setMatchedDetails(Map<String, CategoryDetails> matchedDetails) {
        this.matchedDetails = matchedDetails;
    }

    public Categories withMatchedDetails(Map<String, CategoryDetails> matchedDetails) {
        this.setMatchedDetails(matchedDetails);
        return this;
    }

    public Categories addMatchedDetailsEntry(String key, CategoryDetails value) {
        if (null == this.matchedDetails) {
            this.matchedDetails = new HashMap<String, CategoryDetails>();
        }
        if (this.matchedDetails.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.matchedDetails.put(key, value);
        return this;
    }

    public Categories clearMatchedDetailsEntries() {
        this.matchedDetails = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMatchedCategories() != null) {
            sb.append("MatchedCategories: ").append(this.getMatchedCategories()).append(",");
        }
        if (this.getMatchedDetails() != null) {
            sb.append("MatchedDetails: ").append(this.getMatchedDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Categories)) {
            return false;
        }
        Categories other = (Categories)obj;
        if (other.getMatchedCategories() == null ^ this.getMatchedCategories() == null) {
            return false;
        }
        if (other.getMatchedCategories() != null && !other.getMatchedCategories().equals(this.getMatchedCategories())) {
            return false;
        }
        if (other.getMatchedDetails() == null ^ this.getMatchedDetails() == null) {
            return false;
        }
        return other.getMatchedDetails() == null || other.getMatchedDetails().equals(this.getMatchedDetails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMatchedCategories() == null ? 0 : this.getMatchedCategories().hashCode());
        hashCode = 31 * hashCode + (this.getMatchedDetails() == null ? 0 : this.getMatchedDetails().hashCode());
        return hashCode;
    }

    public Categories clone() {
        try {
            return (Categories)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CategoriesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

